package eu.dnetlib.data.mapreduce.hbase.dedup.fixrelation;

import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;

import java.io.IOException;

import static eu.dnetlib.data.mapreduce.util.DedupUtils.isRoot;
import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.getBody;
import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.rel;

/**
 * Created by sandro on 2/24/17.
 */
public class DedupFixRelationMapper extends TableMapper<Key, ImmutableBytesWritable> {

    public static final String COUNTER_GROUP = "Fix relations";

    private ImmutableBytesWritable ibw;

    private TypeProtos.Type expectedType;

    @Override
    protected void setup(final Context context) {

        expectedType = TypeProtos.Type.valueOf(context.getConfiguration().get("type"));

        ibw = new ImmutableBytesWritable();
    }
    @Override
    protected void map(ImmutableBytesWritable key, Result value, Context context) throws IOException, InterruptedException {
        final String rowKey = new String(key.copyBytes());
        final OafRowKeyDecoder rowKeyDecoder = OafRowKeyDecoder.decode(rowKey);
        final TypeProtos.Type type = rowKeyDecoder.getType();

        if (!type.equals(expectedType) || !isRoot(rowKey)) {
            return;
        }

        final OafProtos.Oaf oaf = getBody(value, type);
        if (oaf == null) {
            context.getCounter(COUNTER_GROUP, String.format("%s - missing body", type.toString())).increment(1);
            return;
        }

        rel(value).forEach(rel -> {
            final String targetId = rel.getRel().getTarget();
            if (!isRoot(targetId)) {
                if (rel.getRel().getRelClass().equals("merges")) {
                    emit(context, Key.mergesRel(targetId), rel.toByteArray());
                } else {
                    emit(context, Key.otherRel(targetId), rel.toByteArray());
                }
            }
        });
    }

    private void emit(final Context context, final Key key, final byte[] value) {
        ibw.set(value);
        switch (key.getKeyType().get()) {
            case Key.MERGES_REL:
                context.getCounter(COUNTER_GROUP, String.format("%s - Merge Relationship", expectedType)).increment(1);
                break;
            case Key.OTHER_REL:
                context.getCounter(COUNTER_GROUP, String.format("%s - Other Relationship", expectedType)).increment(1);
                break;
        }
        try {
            context.write(key, ibw);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}