/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories;

import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories.InstOrgKey;
import eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories.ResultCountryIterator;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PropagationCountryFromDsOrgResultReducer
extends TableReducer<InstOrgKey, Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(PropagationCountryFromDsOrgResultReducer.class);
    private ImmutableBytesWritable keyOut;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
    }

    protected void reduce(InstOrgKey key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        ResultCountryIterator rh = null;
        try {
            rh = new ResultCountryIterator(values, key.getKeyType().get());
        }
        catch (NotValidResultSequenceException e) {
            context.getCounter("Propagation", e.getMessage()).increment(1L);
            return;
        }
        context.getCounter("Propagation", "institutional datasource").increment(1L);
        while (rh.hasNext()) {
            try {
                Object oap = ((ResultIterator)rh).next();
                byte[] oafUpdate = ((OafProtos.Oaf)oap.get(0)).toByteArray();
                byte[] targetRowKey = Bytes.toBytes((String)((OafProtos.Oaf)oap.get(0)).getEntity().getId());
                OafRowKeyDecoder.decode((byte[])targetRowKey);
                Put put = new Put(targetRowKey).add(Bytes.toBytes((String)"result"), Bytes.toBytes((String)("update_" + System.nanoTime())), oafUpdate);
                this.keyOut.set(targetRowKey);
                context.write((Object)this.keyOut, (Object)put);
                context.getCounter("Propagation", "added country to product").increment(1L);
            }
            catch (IllegalArgumentException e) {
                context.getCounter("Propagation", "not valid result id in result list for country propagation").increment(1L);
            }
        }
        if (!rh.getPropagate()) {
            context.getCounter("Propagation", "resultId expected in ordering was not found").increment(1L);
        }
    }
}

