package eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware;

import com.google.common.collect.Lists;
import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.List;

public class ReturnedValues {

    private String openAireId; //openaireid of the publication

    private List<Identifier> publicationPIDs = Lists.newArrayList();

    private List<SoftwareResource> linkedSW = Lists.newLinkedList();

    public String getOpenAireId() {
        return openAireId;
    }

    public ReturnedValues setOpenAireId(String openAireId) {
        this.openAireId = openAireId;
        return this;
    }


    public String toJson() {
        return new Gson().toJson(this);
    }



    public static ReturnedValues newInstance(){
        return new ReturnedValues();
    }


    public List<Identifier> getPublicationPIDs() {
        return publicationPIDs;
    }

    public ReturnedValues setPublicationPIDs(List<Identifier> publicationPIDs) {
        this.publicationPIDs = publicationPIDs;
        return this;
    }

    public List<SoftwareResource> getLinkedSW() {
        return linkedSW;
    }

    public ReturnedValues setLinkedSW(List<SoftwareResource> linkedSW) {
        this.linkedSW = linkedSW;
        return this;
    }

    public static ReturnedValues fromJson(final String json) {
        return new Gson().fromJson(json, ReturnedValues.class);
    }

}
