package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.OafProtos;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

import java.io.IOException;

public class GridAcImportMapper extends Mapper<LongWritable, Text, Text, Text> {

    private String setName;
    private Agent agent;
    private Text keyout;
    private Text valueOut;
    private ActionFactory factory;

    @Override
    protected void setup(Context context) throws IOException, InterruptedException {
        setName = context.getConfiguration().get("setName");
        agent = new Agent(context.getConfiguration().get("agentId"), context.getConfiguration().get("agentName"), Agent.AGENT_TYPE.service);
        keyout = new Text("");
        valueOut = new Text("");
        factory = new ActionFactory();
    }

    @Override
    protected void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
        final String inputJson = value.toString();
        final OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
        JsonFormat.merge(value.toString(), oaf);

        try {
            final AtomicAction action = GridAcToActions.generateActionsFromDump(oaf.build(), factory, setName, agent);

            keyout.set(action.getRowKey());
            valueOut.set(action.toJSON());
            context.write(keyout, valueOut);

        } catch (Throwable e) {
            System.err.println(inputJson);
            throw e;
        }


    }


}
