package eu.dnetlib.data.mapreduce.hbase.dedup.fixrelation;

import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Key implements Writable, WritableComparable<Key> {

    public final static int MERGES_REL = 0;
    public final static int OTHER_REL = 1;

    private IntWritable keyType;

    private Text id;

    public Key() {}

    public Key(final int keyType, final String id) {
        this.id = new Text(id);
        this.keyType = new IntWritable(keyType);
    }

    public static Key create(final int keyType, final String id) {
        return new Key(keyType, id);
    }

    public static Key mergesRel(final String id) {
        return new Key(MERGES_REL, id);
    }

    public static Key otherRel(final String id) {
        return new Key(OTHER_REL, id);
    }

    public Text getId() {
        return id;
    }

    public void setId(final Text id) {
        this.id = id;
    }

    public IntWritable getKeyType() {
        return keyType;
    }

    public void setKeyType(final IntWritable keyType) {
        this.keyType = keyType;
    }

    @Override
    public int compareTo(final Key o) {
        int compareValue = this.id.toString().compareTo(o.getId().toString());
        if (compareValue == 0) {
            compareValue = this.keyType.compareTo(o.getKeyType());
        }
        return compareValue;    // sort ascending
    }

    @Override
    public void write(final DataOutput out) throws IOException {
        keyType.write(out);
        id.write(out);
    }

    @Override
    public void readFields(final DataInput in) throws IOException {
        keyType = new IntWritable();
        keyType.readFields(in);
        id = new Text();
        id.readFields(in);
    }

    @Override
    public String toString() {
        return (new StringBuilder())
                .append('{')
                .append(getKeyType().get())
                .append(',')
                .append(getId())
                .append('}')
                .toString();
    }
}
