package eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import java.io.IOException;
import java.util.Map;

public class SemanticRelationCounter extends TableMapper<ImmutableBytesWritable, Writable> {

    private String[] sem_rels;

    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {
        super.setup(context);

        String[] default_set = {"resultResult_supplement_isSupplementedBy"};

        sem_rels = context.getConfiguration().getStrings("propagatetoproject.semanticrelations",default_set);
        if (sem_rels.length == 0)
            throw new InterruptedException("No semantic relation over which propagate is specified");
    }

    @Override
    protected void map(final ImmutableBytesWritable key, final Result value, final Context context) throws IOException, InterruptedException {

        final Map<byte[], byte[]> resultMap = value.getFamilyMap(Bytes.toBytes("result"));

        final byte[] body = resultMap.get(Bytes.toBytes("body"));


        if (body != null) {
            final Oaf res_oaf = Oaf.parseFrom(body);
            if (res_oaf.getDataInfo().getDeletedbyinference()){
                context.getCounter("Relation counter","del by inference result").increment(1);
                return;
            }
            context.getCounter("Relation counter", "not null body ").increment(1);
            boolean foundRelation = false;
            for (String sem_rel : sem_rels)
                foundRelation = foundRelation || countRelation(sem_rel,context,value);
            if(countRelation("resultProject_outcome_isProducedBy",context,value)){
                if (foundRelation)
                    context.getCounter("Relation counter", "Association to project in result with semantic relation" ).increment(1);
            }

        }
    }

    private boolean countRelation(String rel_to_find, Context context, Result value) throws InvalidProtocolBufferException {
        final Map<byte[], byte[]> relationMap = value.getFamilyMap(Bytes.toBytes(rel_to_find));
        boolean ret = false;
        for(byte[] relation:relationMap.values() ){
            final Oaf rel_oaf = Oaf.parseFrom(relation);
            if (!isValid(rel_oaf)) {
                context.getCounter("Relation counter", rel_to_find + " not present in relation set").increment(1);
                return ret;
            }
            if (rel_oaf.getDataInfo().getDeletedbyinference()){
                context.getCounter("Relation counter ",rel_to_find + " del by inference" ).increment(1);

            }else{
                context.getCounter("Relation counter ",rel_to_find ).increment(1);
                ret = true;
            }
        }
        return ret;
    }



    private boolean isValid(final Oaf oaf) {
        return (oaf != null) && oaf.isInitialized();
    }
}
