/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories;

import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.io.Text;

public class ResultCountryIterator
extends ResultIterator {
    private String country;

    public ResultCountryIterator(Iterable<Text> values, int key) throws NotValidResultSequenceException {
        super(values, key);
    }

    @Override
    protected void checkSequence() throws NotValidResultSequenceException {
        if (!this.it.hasNext()) {
            throw new NotValidResultSequenceException("Empty information for key");
        }
        Value first = Value.fromJson(((Text)this.it.next()).toString());
        this.trust = first.getTrust();
        if (!first.getValue().equals("0") && !first.getValue().equals("1")) {
            if (this.key != TypeProtos.Type.datasource.getNumber()) {
                throw new NotValidResultSequenceException("First Element in reducer is not type of datasource,  but the organization exists");
            }
            while (this.it.hasNext()) {
                this.resultId = Value.fromJson(((Text)this.it.next()).toString()).getValue();
                if (this.resultId.startsWith("50|")) continue;
                throw new NotValidResultSequenceException("ERROR ORDERING CHECK");
            }
            throw new NotValidResultSequenceException("WARNING: unexpected first element");
        }
        if (first.getValue().equals("1")) {
            if (!this.it.hasNext()) {
                throw new NotValidResultSequenceException("No information apart of type of datasource");
            }
            this.country = Value.fromJson(((Text)this.it.next()).toString()).getValue();
            if (this.country.trim().length() != 2) {
                try {
                    Integer.parseInt(this.country.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new NotValidResultSequenceException("Second element in reducer is not country");
            }
            boolean iterate = true;
            this.resultId = "FINITO";
            while (this.it.hasNext() && iterate) {
                this.resultId = Value.fromJson(((Text)this.it.next()).toString()).getValue();
                if (!this.resultId.startsWith("50|")) {
                    if (this.resultId.equalsIgnoreCase(this.country)) continue;
                    this.propagate = false;
                    iterate = false;
                    continue;
                }
                this.propagate = true;
                iterate = false;
            }
            if (!this.resultId.equals("FINITO")) {
                try {
                    OafRowKeyDecoder.decode((String)this.resultId);
                }
                catch (IllegalArgumentException e) {
                    throw new NotValidResultSequenceException("No result in sequence");
                }
            }
        } else {
            throw new NotValidResultSequenceException("Not allowed dsType institutional datasource");
        }
    }

    @Override
    public List<OafProtos.Oaf> next() {
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder().addCountry(Utils.getCountry(this.country, this.trust, "dnet:countries", "propagation:country:instrepos", "dnet:provenanceActions", "dnet:provenanceActions", "propagation", "Propagation of country information from datasources belonging to institutional repositories"));
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder().setMetadata(metadata);
        OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result).setId(this.resultId).setResult(result);
        this.resultId = this.it.hasNext() ? Value.fromJson(((Text)this.it.next()).toString()).getValue() : "FINITO";
        return new ArrayList<OafProtos.Oaf>(Arrays.asList(OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.entity).setEntity(entity).build()));
    }
}

