/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.fixrelation;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.dedup.fixrelation.Key;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.mapreduce.util.OafRelDecoder;
import eu.dnetlib.data.mapreduce.util.RelDescriptor;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.utils.ontologies.Ontologies;
import eu.dnetlib.utils.ontologies.Ontology;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;

public class DedupFixRelationReducer
extends TableReducer<Key, ImmutableBytesWritable, ImmutableBytesWritable> {
    public static final String COUNTER_GROUP = "Fix relations";
    private Ontologies ontologies;
    private boolean simulation;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.simulation = context.getConfiguration().getBoolean("fixrel.simulation", false);
        this.ontologies = (Ontologies)new Gson().fromJson(context.getConfiguration().get("ontologies"), Ontologies.class);
        System.out.println("ontologies: " + this.ontologies.toJson(true));
    }

    protected void reduce(Key key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) {
        if (DedupUtils.isRoot(key.toString())) {
            System.err.println("aborting DedupFixRelationReducer, found root key: " + key);
            context.getCounter(COUNTER_GROUP, "aborted").increment(1L);
            return;
        }
        Iterator<ImmutableBytesWritable> it = values.iterator();
        OafProtos.Oaf first = OafDecoder.decode((byte[])it.next().copyBytes()).getOaf();
        if (!first.getRel().getRelClass().equals("merges")) {
            context.getCounter(COUNTER_GROUP, "Relation skipped").increment(1L);
            return;
        }
        context.getCounter(COUNTER_GROUP, "Item to fix").increment(1L);
        String dedupRoot = first.getRel().getSource();
        it.forEachRemaining(b -> {
            try {
                this.handleRels(context, OafDecoder.decode((byte[])b.copyBytes()).getOaf(), dedupRoot);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void handleRels(Reducer.Context context, OafProtos.Oaf oaf, String dedupRoot) throws IOException, InterruptedException {
        String relType = oaf.getRel().getRelClass();
        if (relType.contains("merges")) {
            return;
        }
        FieldTypeProtos.DataInfo.Builder dataInfoBuilder = FieldTypeProtos.DataInfo.newBuilder((FieldTypeProtos.DataInfo)oaf.getDataInfo());
        dataInfoBuilder.setDeletedbyinference(true);
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)oaf);
        builder.setDataInfo(dataInfoBuilder.build());
        String sourceKey = oaf.getRel().getSource();
        this.write(context, sourceKey, builder);
        String relGroup = oaf.getRel().getRelType().toString() + oaf.getRel().getSubRelType().toString();
        context.getCounter(COUNTER_GROUP, String.format("%s - Relation set deleted", relGroup)).increment(1L);
        builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)oaf);
        OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder((OafProtos.OafRel)oaf.getRel());
        relBuilder.setTarget(dedupRoot);
        builder.setRel(relBuilder.build());
        this.write(context, sourceKey, builder);
        relBuilder = OafProtos.OafRel.newBuilder((OafProtos.OafRel)oaf.getRel());
        relBuilder.setTarget(relBuilder.getSource());
        relBuilder.setSource(dedupRoot);
        RelDescriptor rd = OafRelDecoder.decode((OafProtos.OafRel)oaf.getRel()).getRelDescriptor();
        String inverseRelation = ((Ontology)this.ontologies.get((Object)rd.getRelType().toString())).inverseOf(rd.getRelClass());
        relBuilder.setRelType(rd.getRelType()).setSubRelType(rd.getSubRelType()).setRelClass(inverseRelation);
        builder.setRel(relBuilder.build());
        this.write(context, dedupRoot, builder);
        relGroup = oaf.getRel().getRelType().toString() + oaf.getRel().getSubRelType().toString();
        context.getCounter(COUNTER_GROUP, String.format("%s - Relation fixed", relGroup)).increment(2L);
    }

    private void write(Reducer.Context context, String dedupRoot, OafProtos.Oaf.Builder builder) throws IOException, InterruptedException {
        if (!this.simulation) {
            context.write((Object)new ImmutableBytesWritable(Bytes.toBytes((String)dedupRoot)), (Object)OafHbaseUtils.asPut(builder.build()));
        }
    }
}

