/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories;

import com.google.common.collect.ComparisonChain;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class InstOrgKey
implements WritableComparable<InstOrgKey> {
    private IntWritable keyType;
    private Text id;

    public InstOrgKey() {
    }

    public static InstOrgKey create(int keyType, String id) {
        return new InstOrgKey(keyType, id);
    }

    public static InstOrgKey datasource(String id) {
        return new InstOrgKey(PropagationConstants.DATASOURCE, id);
    }

    public static InstOrgKey organization(String id) {
        return new InstOrgKey(PropagationConstants.ORGANIZATION, id);
    }

    public static InstOrgKey publication(String id) {
        return new InstOrgKey(PropagationConstants.PUBLICATION, id);
    }

    public InstOrgKey(int keyType, String id) {
        this.id = new Text(id);
        this.keyType = new IntWritable(keyType);
    }

    public void setKeyType(IntWritable keyType) {
        this.keyType = keyType;
    }

    public void setId(Text id) {
        this.id = id;
    }

    public Text getId() {
        return this.id;
    }

    public IntWritable getKeyType() {
        return this.keyType;
    }

    public int compareTo(InstOrgKey o) {
        int res = ComparisonChain.start().compare((Comparable)this.getId(), (Comparable)o.getId()).compare((Comparable)this.getKeyType(), (Comparable)o.getKeyType()).result();
        return res;
    }

    public void write(DataOutput out) throws IOException {
        this.keyType.write(out);
        this.id.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.keyType = new IntWritable();
        this.keyType.readFields(in);
        this.id = new Text();
        this.id.readFields(in);
    }

    public String toString() {
        return "" + '{' + this.getKeyType().get() + ',' + this.getId() + '}';
    }
}

