/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.bulktag;

import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import eu.dnetlib.data.bulktag.CommunityConfiguration;
import eu.dnetlib.data.bulktag.Pair;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.mapreduce.Mapper;

public class ResultTagger {
    private static final String DATA_INFO_TYPE = "bulktagging";
    private static final String SCHEMA_NAME = "dnet:provenanceActions";
    private static final String CLASS_ID_SUBJECT = "bulktagging:community:subject";
    private static final String CLASS_ID_DATASOURCE = "bulktagging:community:datasource";
    private static final String CLASS_ID_CZENODO = "bulktagging:community:zenodocommunity";
    private static final String SCHEMA_ID = "dnet:provenanceActions";
    private static final String COUNTER_GROUP = "Bulk Tagging";
    private static final String ZENODO_COMMUNITY_INDICATOR = "zenodo.org/communities/";
    private String trust = "0.8";

    private boolean clearContext(ResultProtos.Result.Metadata.Builder mBuilder) {
        int tmp = mBuilder.getContextBuilderList().size();
        List<ResultProtos.Result.Context.Builder> clist = mBuilder.getContextBuilderList().stream().filter(c -> !c.getId().contains(ZENODO_COMMUNITY_INDICATOR)).collect(Collectors.toList());
        mBuilder.clearContext();
        clist.forEach(c -> mBuilder.addContext(c));
        return tmp != clist.size();
    }

    public Map<String, List<String>> getParamMap(OafProtos.Oaf oaf, Map<String, String> params) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        String json = JsonFormat.printToString((Message)oaf);
        DocumentContext jsonContext = JsonPath.parse((String)json);
        if (params == null) {
            params = new HashMap<String, String>();
        }
        for (String key : params.keySet()) {
            try {
                param.put(key, (List<String>)jsonContext.read(params.get(key), new Predicate[0]));
            }
            catch (PathNotFoundException e) {
                param.put(key, new ArrayList());
            }
        }
        return param;
    }

    public OafProtos.Oaf enrichContextCriteria(OafProtos.Oaf oaf, CommunityConfiguration conf, Mapper.Context context, Map<String, String> criteria) {
        Map<String, List<String>> param = this.getParamMap(oaf, criteria);
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)oaf);
        ResultProtos.Result.Metadata.Builder mBuilder = builder.getEntityBuilder().getResultBuilder().getMetadataBuilder();
        if (oaf.getDataInfo().getDeletedbyinference()) {
            context.getCounter(COUNTER_GROUP, "deleted by inference").increment(1L);
            if (!this.clearContext(mBuilder)) {
                return null;
            }
            context.getCounter(COUNTER_GROUP, "removed zenodo community context in del by inference record").increment(1L);
            return builder.build();
        }
        HashSet communities = new HashSet();
        HashSet subjects = new HashSet();
        oaf.getEntity().getResult().getMetadata().getSubjectList().stream().map(subject -> subject.getValue()).filter(StringUtils::isNotBlank).map(String::toLowerCase).map(String::trim).collect(Collectors.toCollection(HashSet::new)).forEach(s -> subjects.addAll(conf.getCommunityForSubjectValue(s)));
        subjects.forEach(c -> context.getCounter(COUNTER_GROUP, "Matching subject for community " + c).increment(1L));
        communities.addAll(subjects);
        context.getCounter(COUNTER_GROUP, "match found for subjects ").increment((long)subjects.size());
        HashSet datasources = new HashSet();
        HashSet<String> tmp = new HashSet<String>();
        for (ResultProtos.Result.Instance i2 : oaf.getEntity().getResult().getInstanceList()) {
            tmp.add(StringUtils.substringAfter((String)i2.getCollectedfrom().getKey(), (String)"|"));
            tmp.add(StringUtils.substringAfter((String)i2.getHostedby().getKey(), (String)"|"));
        }
        oaf.getEntity().getResult().getInstanceList().stream().map(i -> new Pair((Object)i.getCollectedfrom().getKey(), (Object)i.getHostedby().getKey())).flatMap(p -> Stream.of((String)p.getFst(), (String)p.getSnd())).map(s -> StringUtils.substringAfter((String)s, (String)"|")).collect(Collectors.toCollection(HashSet::new)).forEach(dsId -> datasources.addAll(conf.getCommunityForDatasource(dsId, param)));
        datasources.forEach(c -> context.getCounter(COUNTER_GROUP, "Matching datasource for community " + c).increment(1L));
        communities.addAll(datasources);
        context.getCounter(COUNTER_GROUP, "Match found for content providers ").increment((long)datasources.size());
        HashSet czenodo = new HashSet();
        mBuilder.getContextBuilderList().stream().filter(cBuilder -> cBuilder.getId().contains(ZENODO_COMMUNITY_INDICATOR)).collect(Collectors.toList()).forEach(c -> czenodo.addAll(conf.getCommunityForZenodoCommunityValue(c.getId().substring(c.getId().lastIndexOf("/") + 1).trim())));
        czenodo.forEach(c -> context.getCounter(COUNTER_GROUP, "Matching Zenodo community for community " + c).increment(1L));
        context.getCounter(COUNTER_GROUP, "Match found for Zenodo communities ").increment((long)czenodo.size());
        communities.addAll(czenodo);
        boolean removed = this.clearContext(mBuilder);
        if (communities.isEmpty()) {
            context.getCounter(COUNTER_GROUP, "list of communities empty").increment(1L);
            if (!removed) {
                return null;
            }
            context.getCounter(COUNTER_GROUP, "removed Zenodo community from result not to be enriched").increment(1L);
            return builder.build();
        }
        context.getCounter(COUNTER_GROUP, "list of communities has values!").increment(1L);
        HashMap cBuilders = Maps.newHashMap();
        mBuilder.getContextBuilderList().forEach(cBuilder -> cBuilders.put(cBuilder.getId(), cBuilder));
        for (String contextId : communities) {
            ResultProtos.Result.Context.Builder cBuilder2 = (ResultProtos.Result.Context.Builder)cBuilders.get(contextId);
            if (cBuilder2 != null) {
                if (!cBuilder2.getDataInfoBuilderList().stream().map(di -> di.getInferenceprovenance()).anyMatch(s -> DATA_INFO_TYPE.equals(s))) {
                    if (subjects.contains(contextId)) {
                        cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_SUBJECT));
                    }
                    if (datasources.contains(contextId)) {
                        cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_DATASOURCE));
                    }
                    if (czenodo.contains(contextId)) {
                        cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_CZENODO));
                    }
                    context.getCounter(COUNTER_GROUP, "add provenance").increment(1L);
                    continue;
                }
                context.getCounter(COUNTER_GROUP, "provenance already bulk tagged").increment(1L);
                continue;
            }
            context.getCounter(COUNTER_GROUP, "add context").increment(1L);
            cBuilder2 = ResultProtos.Result.Context.newBuilder().setId(contextId);
            if (subjects.contains(contextId)) {
                cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_SUBJECT));
            }
            if (datasources.contains(contextId)) {
                cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_DATASOURCE));
            }
            if (czenodo.contains(contextId)) {
                cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_CZENODO));
            }
            mBuilder.addContext(cBuilder2.build());
        }
        return builder.build();
    }

    public OafProtos.Oaf enrichContext(OafProtos.Oaf oaf, CommunityConfiguration conf, Mapper.Context context) {
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)oaf);
        ResultProtos.Result.Metadata.Builder mBuilder = builder.getEntityBuilder().getResultBuilder().getMetadataBuilder();
        if (oaf.getDataInfo().getDeletedbyinference()) {
            context.getCounter(COUNTER_GROUP, "deleted by inference").increment(1L);
            if (!this.clearContext(mBuilder)) {
                return null;
            }
            context.getCounter(COUNTER_GROUP, "removed zenodo community context in del by inference record").increment(1L);
            return builder.build();
        }
        HashSet communities = new HashSet();
        HashSet subjects = new HashSet();
        oaf.getEntity().getResult().getMetadata().getSubjectList().stream().map(subject -> subject.getValue()).filter(StringUtils::isNotBlank).map(String::toLowerCase).map(String::trim).collect(Collectors.toCollection(HashSet::new)).forEach(s -> subjects.addAll(conf.getCommunityForSubjectValue(s)));
        subjects.forEach(c -> context.getCounter(COUNTER_GROUP, "Matching subject for community " + c).increment(1L));
        communities.addAll(subjects);
        context.getCounter(COUNTER_GROUP, "match found for subjects ").increment((long)subjects.size());
        HashSet datasources = new HashSet();
        HashSet<String> tmp = new HashSet<String>();
        for (ResultProtos.Result.Instance i2 : oaf.getEntity().getResult().getInstanceList()) {
            tmp.add(StringUtils.substringAfter((String)i2.getCollectedfrom().getKey(), (String)"|"));
            tmp.add(StringUtils.substringAfter((String)i2.getHostedby().getKey(), (String)"|"));
        }
        oaf.getEntity().getResult().getInstanceList().stream().map(i -> new Pair((Object)i.getCollectedfrom().getKey(), (Object)i.getHostedby().getKey())).flatMap(p -> Stream.of((String)p.getFst(), (String)p.getSnd())).map(s -> StringUtils.substringAfter((String)s, (String)"|")).collect(Collectors.toCollection(HashSet::new)).forEach(dsId -> datasources.addAll(conf.getCommunityForDatasourceValue(dsId)));
        datasources.forEach(c -> context.getCounter(COUNTER_GROUP, "Matching datasource for community " + c).increment(1L));
        communities.addAll(datasources);
        context.getCounter(COUNTER_GROUP, "Match found for content providers ").increment((long)datasources.size());
        HashSet czenodo = new HashSet();
        mBuilder.getContextBuilderList().stream().filter(cBuilder -> cBuilder.getId().contains(ZENODO_COMMUNITY_INDICATOR)).collect(Collectors.toList()).forEach(c -> czenodo.addAll(conf.getCommunityForZenodoCommunityValue(c.getId().substring(c.getId().lastIndexOf("/") + 1).trim())));
        czenodo.forEach(c -> context.getCounter(COUNTER_GROUP, "Matching Zenodo community for community " + c).increment(1L));
        context.getCounter(COUNTER_GROUP, "Match found for Zenodo communities ").increment((long)czenodo.size());
        communities.addAll(czenodo);
        boolean removed = this.clearContext(mBuilder);
        if (communities.isEmpty()) {
            context.getCounter(COUNTER_GROUP, "list of communities empty").increment(1L);
            if (!removed) {
                return null;
            }
            context.getCounter(COUNTER_GROUP, "removed Zenodo community from result not to be enriched").increment(1L);
            return builder.build();
        }
        context.getCounter(COUNTER_GROUP, "list of communities has values!").increment(1L);
        HashMap cBuilders = Maps.newHashMap();
        mBuilder.getContextBuilderList().forEach(cBuilder -> cBuilders.put(cBuilder.getId(), cBuilder));
        for (String contextId : communities) {
            ResultProtos.Result.Context.Builder cBuilder2 = (ResultProtos.Result.Context.Builder)cBuilders.get(contextId);
            if (cBuilder2 != null) {
                if (!cBuilder2.getDataInfoBuilderList().stream().map(di -> di.getInferenceprovenance()).anyMatch(s -> DATA_INFO_TYPE.equals(s))) {
                    if (subjects.contains(contextId)) {
                        cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_SUBJECT));
                    }
                    if (datasources.contains(contextId)) {
                        cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_DATASOURCE));
                    }
                    if (czenodo.contains(contextId)) {
                        cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_CZENODO));
                    }
                    context.getCounter(COUNTER_GROUP, "add provenance").increment(1L);
                    continue;
                }
                context.getCounter(COUNTER_GROUP, "provenance already bulk tagged").increment(1L);
                continue;
            }
            context.getCounter(COUNTER_GROUP, "add context").increment(1L);
            cBuilder2 = ResultProtos.Result.Context.newBuilder().setId(contextId);
            if (subjects.contains(contextId)) {
                cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_SUBJECT));
            }
            if (datasources.contains(contextId)) {
                cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_DATASOURCE));
            }
            if (czenodo.contains(contextId)) {
                cBuilder2.addDataInfo(this.buildDataInfo(CLASS_ID_CZENODO));
            }
            mBuilder.addContext(cBuilder2.build());
        }
        return builder.build();
    }

    private FieldTypeProtos.DataInfo buildDataInfo(String class_id) {
        FieldTypeProtos.DataInfo.Builder builder = FieldTypeProtos.DataInfo.newBuilder().setInferred(true).setProvenanceaction(FieldTypeProtos.Qualifier.newBuilder().setClassid(class_id).setClassname("Bulk Tagging for Communities").setSchemeid("dnet:provenanceActions").setSchemename("dnet:provenanceActions")).setInferenceprovenance(DATA_INFO_TYPE).setTrust(this.trust);
        return builder.build();
    }

    public void setTrust(String s) {
        this.trust = s;
    }
}

