/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ConfigurableExportMapper
extends TableMapper<Text, Text> {
    private static final String CF_DEFAULT = "result";
    private static final String QUALIFIER_DEFAULT = "body";
    private Text keyOut;
    private Text valueOut;
    private Set<String> columnFamilies = Sets.newHashSet();
    private Set<String> qualifiers = Sets.newHashSet();
    private ExportMode exportMode = ExportMode.ALL;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.keyOut = new Text("");
        this.valueOut = new Text();
        this.columnFamilies.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)context.getConfiguration().get("column.families", CF_DEFAULT))));
        this.qualifiers.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)context.getConfiguration().get("qualifiers", QUALIFIER_DEFAULT))));
        this.exportMode = ExportMode.valueOf(context.getConfiguration().get("export.mode", ExportMode.ALL.toString()));
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        for (String cf : this.columnFamilies) {
            switch (this.exportMode) {
                case ALL: {
                    this.export(value, context, cf);
                    break;
                }
                case DUPS_ONLY: {
                    NavigableMap mergedInMap = value.getFamilyMap(DedupUtils.getDedupCF_mergedInBytes(cf));
                    if (mergedInMap == null || mergedInMap.isEmpty()) break;
                    this.export(value, context, cf);
                }
            }
        }
    }

    private void export(Result value, Mapper.Context context, String cf) throws IOException, InterruptedException {
        for (String q : this.qualifiers) {
            byte[] data = value.getValue(cf.getBytes(), q.getBytes());
            if (data == null) continue;
            OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])data);
            this.valueOut.set(JsonFormat.printToString((Message)oaf));
            context.write((Object)this.keyOut, (Object)this.valueOut);
            context.getCounter(cf, q).increment(1L);
        }
    }

    static enum ExportMode {
        ALL,
        DUPS_ONLY;

    }
}

