/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.hbase.Reporter;
import eu.dnetlib.data.mapreduce.hbase.dataimport.DumpToActionsUtility;
import eu.dnetlib.data.mapreduce.util.StreamUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultOrganizationProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.miscutils.collections.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class DOIBoostToActions {
    public static final String MAG = "MAG";
    public static final String ORCID = "ORCID";
    public static final String CROSSREF = "Crossref";
    public static final String UNPAYWALL = "UnpayWall";
    public static final String GRID_AC = "grid.ac";
    public static final String WIKPEDIA = "wikpedia";
    public static final String doiBoostNSPREFIX = "doiboost____";
    public static final String OPENAIRE_PREFIX = "openaire____";
    public static final String SEPARATOR = "::";
    public static final String DNET_LANGUAGES = "dnet:languages";
    private static Map<String, Pair<String, String>> datasources = new HashMap<String, Pair<String, String>>(){
        {
            this.put(DOIBoostToActions.MAG.toLowerCase(), new Pair((Object)"Microsoft Academic Graph", (Object)"openaire____::microsoft"));
            this.put(DOIBoostToActions.ORCID.toLowerCase(), new Pair((Object)DOIBoostToActions.ORCID, (Object)"openaire____::orcid"));
            this.put(DOIBoostToActions.CROSSREF.toLowerCase(), new Pair((Object)DOIBoostToActions.CROSSREF, (Object)"openaire____::crossref"));
            this.put(DOIBoostToActions.UNPAYWALL.toLowerCase(), new Pair((Object)DOIBoostToActions.UNPAYWALL, (Object)"openaire____::unpaywall"));
        }
    };
    public static final String PID_TYPES = "dnet:pid_types";
    private static Map<String, FieldTypeProtos.Qualifier> affiliationPIDType = new HashMap<String, FieldTypeProtos.Qualifier>(){
        {
            this.put(DOIBoostToActions.MAG, FieldTypeProtos.Qualifier.newBuilder().setClassid("mag_id").setClassname("Microsoft Academic Graph Identifier").setSchemename(DOIBoostToActions.PID_TYPES).setSchemeid(DOIBoostToActions.PID_TYPES).build());
            this.put(DOIBoostToActions.GRID_AC, DumpToActionsUtility.getQualifier("grid", DOIBoostToActions.PID_TYPES));
            this.put(DOIBoostToActions.WIKPEDIA, DumpToActionsUtility.getQualifier("urn", DOIBoostToActions.PID_TYPES));
        }
    };
    static Map<String, Map<String, String>> typologiesMapping;

    private static String decompressAbstract(String abstractCompressed) {
        try {
            byte[] byteArray = Base64.decodeBase64((byte[])abstractCompressed.getBytes());
            Inflater decompresser = new Inflater();
            decompresser.setInput(byteArray);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(byteArray.length);
            byte[] buffer = new byte[8192];
            while (!decompresser.finished()) {
                int size = decompresser.inflate(buffer);
                bos.write(buffer, 0, size);
            }
            byte[] unzippeddata = bos.toByteArray();
            decompresser.end();
            return new String(unzippeddata);
        }
        catch (Throwable e) {
            System.out.println("Wrong abstract:" + abstractCompressed);
            throw new RuntimeException(e);
        }
    }

    protected static boolean isValid(JsonObject rootElement, Reporter context) {
        String doi = DumpToActionsUtility.getStringValue(rootElement, "doi");
        if (doi == null) {
            context.incrementCounter("filtered", "no_doi", 1L);
            return false;
        }
        String type = DumpToActionsUtility.getStringValue(rootElement, "type");
        if (!typologiesMapping.containsKey(type)) {
            context.incrementCounter("filtered", "unknowntype_" + type, 1L);
            return false;
        }
        String publisher = DumpToActionsUtility.getStringValue(rootElement, "publisher");
        if (StringUtils.isNotBlank((CharSequence)publisher) && (publisher.equalsIgnoreCase("Test accounts") || publisher.equalsIgnoreCase("CrossRef Test Account"))) {
            context.incrementCounter("filtered", "test_publisher", 1L);
            return false;
        }
        List<JsonObject> authors = DumpToActionsUtility.getArrayObjects(rootElement, "authors");
        boolean hasAuthors = false;
        for (JsonObject author : authors) {
            String given = DumpToActionsUtility.getStringValue(author, "given");
            String family = DumpToActionsUtility.getStringValue(author, "family");
            String fullname = DumpToActionsUtility.getStringValue(author, "fullname");
            if (StringUtils.isBlank((CharSequence)fullname) && StringUtils.isNotBlank((CharSequence)given) && StringUtils.isNotBlank((CharSequence)family)) {
                fullname = String.format("%s %s", given, family);
            }
            if (fullname.equalsIgnoreCase("Addie Jackson") && publisher.equalsIgnoreCase("Elsevier BV")) {
                context.incrementCounter("invalid_author", "addiejackson", 1L);
                context.incrementCounter("filtered", "invalid_authors", 1L);
                return false;
            }
            if (!DOIBoostToActions.isValidAuthorName(fullname, context)) continue;
            hasAuthors = true;
        }
        if (!hasAuthors) {
            context.incrementCounter("filtered", "invalid_authors", 1L);
            return false;
        }
        if (DOIBoostToActions.getCleanedTitles(rootElement).isEmpty()) {
            context.incrementCounter("filtered", "invalid_title", 1L);
            return false;
        }
        return true;
    }

    private static List<String> getCleanedTitles(JsonObject rootElement) {
        List<String> titles = DumpToActionsUtility.getArrayValues(rootElement, "title");
        return titles.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t) && !t.equalsIgnoreCase("[NO TITLE AVAILABLE]")).collect(Collectors.toList());
    }

    private static boolean isValidAuthorName(String fullName, Reporter context) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            if (context != null) {
                context.incrementCounter("invalid_author", "blank", 1L);
            }
            return false;
        }
        switch (StringUtils.lowerCase((String)fullName)) {
            case ",": 
            case "none none": 
            case "none, none": 
            case "none &na;": 
            case "(:null)": 
            case "test test test": 
            case "test test": 
            case "test": 
            case "&na; &na;": {
                if (context != null) {
                    context.incrementCounter("invalid_author", "value_" + fullName, 1L);
                }
                return false;
            }
        }
        return true;
    }

    public static List<AtomicAction> generatePublicationActionsFromDump(JsonObject rootElement, ActionFactory factory, String setName, Agent agent, boolean invisible, boolean onlyOrganization, Reporter context) {
        if (!DOIBoostToActions.isValid(rootElement, context)) {
            return null;
        }
        OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
        oaf.setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setInvisible(invisible).setDeletedbyinference(false).setInferred(false).setTrust("0.9").setProvenanceaction(DumpToActionsUtility.getQualifier("sysimport:actionset", "dnet:provenanceActions")).build());
        oaf.setKind(KindProtos.Kind.entity);
        OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result);
        entity.setDateofcollection("2019-02-15");
        if (rootElement.has("collectedFrom") && rootElement.get("collectedFrom").isJsonArray()) {
            StreamUtils.toStream(rootElement.getAsJsonArray("collectedFrom").iterator()).map(JsonElement::getAsString).forEach(cf -> {
                String id = (String)datasources.get(cf.toLowerCase()).getValue();
                String name = (String)datasources.get(cf.toLowerCase()).getKey();
                if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)name)) {
                    FieldTypeProtos.KeyValue collectedFrom = FieldTypeProtos.KeyValue.newBuilder().setValue(name).setKey("10|openaire____::" + AbstractDNetXsltFunctions.md5((String)StringUtils.substringAfter((String)id, (String)SEPARATOR))).build();
                    entity.addCollectedfrom(collectedFrom);
                }
            });
        }
        String doi = DumpToActionsUtility.getStringValue(rootElement, "doi");
        entity.addOriginalId(doi);
        String sourceId = String.format("50|%s::%s", doiBoostNSPREFIX, AbstractDNetXsltFunctions.md5((String)doi));
        entity.setId(sourceId);
        entity.addPid(FieldTypeProtos.StructuredProperty.newBuilder().setValue(doi).setQualifier(DumpToActionsUtility.getQualifier("doi", PID_TYPES)).build());
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
        String type = DumpToActionsUtility.getStringValue(rootElement, "type");
        String typeValue = typologiesMapping.get(type).get("value");
        String cobjValue = typologiesMapping.get(type).get("cobj");
        List unpaywallLicenses = DumpToActionsUtility.getArrayObjects(rootElement, "license").stream().filter(prov -> {
            String provS = DumpToActionsUtility.getStringValue(prov, "provenance");
            return StringUtils.isNotBlank((CharSequence)provS) && provS.equalsIgnoreCase(UNPAYWALL);
        }).collect(Collectors.toList());
        Stream.concat(unpaywallLicenses.stream(), DumpToActionsUtility.getArrayObjects(rootElement, "instances").stream()).map(it -> {
            String acc_class_value;
            String acc_class_id;
            ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder();
            instance.setInstancetype(FieldTypeProtos.Qualifier.newBuilder().setClassid(cobjValue).setClassname(typeValue).setSchemeid("dnet:publication_resource").setSchemename("dnet:publication_resource").build());
            instance.setHostedby(FieldTypeProtos.KeyValue.newBuilder().setKey("10|openaire____::55045bd2a65019fd8e6741a755395c8c").setValue("Unknown Repository").build());
            switch (acc_class_id = it.get("access-rights").getAsString()) {
                case "OPEN": {
                    acc_class_value = "Open Access";
                    break;
                }
                case "CLOSED": 
                case "RESTRICTED": {
                    acc_class_id = "RESTRICTED";
                    acc_class_value = "Restricted";
                    break;
                }
                case "EMBARGO": {
                    acc_class_value = "Embargo";
                    break;
                }
                default: {
                    acc_class_value = "not available";
                    acc_class_id = "UNKNOWN";
                }
            }
            instance.addUrl(it.get("url").getAsString());
            instance.setAccessright(FieldTypeProtos.Qualifier.newBuilder().setClassid(acc_class_id).setClassname(acc_class_value).setSchemeid("dnet:access_modes").setSchemename("dnet:access_modes").build());
            String id = (String)datasources.get(it.get("provenance").getAsString().toLowerCase()).getValue();
            String name = (String)datasources.get(it.get("provenance").getAsString().toLowerCase()).getKey();
            if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)name)) {
                FieldTypeProtos.KeyValue collectedFrom = FieldTypeProtos.KeyValue.newBuilder().setValue(name).setKey("10|openaire____::" + AbstractDNetXsltFunctions.md5((String)StringUtils.substringAfter((String)id, (String)SEPARATOR))).build();
                instance.setCollectedfrom(collectedFrom);
            }
            return instance.build();
        }).forEach(arg_0 -> ((ResultProtos.Result.Builder)result).addInstance(arg_0));
        String doiURL = DumpToActionsUtility.getStringValue(rootElement, "doi-url");
        JsonObject hostedByOpenAire = null;
        if (rootElement.has("hostedByOpenAire")) {
            hostedByOpenAire = rootElement.getAsJsonObject("hostedByOpenAire");
        }
        String publisher = DumpToActionsUtility.getStringValue(rootElement, "publisher");
        if (StringUtils.isNotBlank((CharSequence)doiURL)) {
            ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder();
            instance.addUrl(doiURL);
            instance.setInstancetype(FieldTypeProtos.Qualifier.newBuilder().setClassid(cobjValue).setClassname(typeValue).setSchemeid("dnet:publication_resource").setSchemename("dnet:publication_resource").build());
            String accessModeId = "RESTRICTED";
            String accessModeName = "Restricted";
            if (publisher != null && publisher.equalsIgnoreCase("FapUNIFESP (SciELO)")) {
                accessModeId = "OPEN";
                accessModeName = "Open Access";
            }
            instance.setAccessright(FieldTypeProtos.Qualifier.newBuilder().setClassid(accessModeId).setClassname(accessModeName).setSchemeid("dnet:access_modes").setSchemename("dnet:access_modes").build());
            instance.setCollectedfrom(FieldTypeProtos.KeyValue.newBuilder().setValue(CROSSREF).setKey("10|openaire____::" + AbstractDNetXsltFunctions.md5((String)"crossref")).build());
            if (hostedByOpenAire == null) {
                instance.setHostedby(FieldTypeProtos.KeyValue.newBuilder().setKey("10|openaire____::55045bd2a65019fd8e6741a755395c8c").setValue("Unknown Repository").build());
            } else {
                instance.setHostedby(FieldTypeProtos.KeyValue.newBuilder().setKey(AbstractDNetXsltFunctions.oafSplitId((String)"datasource", (String)hostedByOpenAire.get("id").getAsString())).setValue(hostedByOpenAire.get("name").getAsString()).build());
            }
            result.addInstance(instance);
        }
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        Pair<List<FieldTypeProtos.Author>, Collection<OafProtos.Oaf>> authorsOrganizations = DOIBoostToActions.createAuthorsOrganization(rootElement);
        if (((List)authorsOrganizations.getKey()).size() <= 0) {
            context.incrementCounter("filtered", "unexpected_no_authors", 1L);
            return null;
        }
        metadata.addAllAuthor((Iterable)authorsOrganizations.getKey());
        metadata.setLanguage(FieldTypeProtos.Qualifier.newBuilder().setClassid("und").setClassname("Undetermined").setSchemeid(DNET_LANGUAGES).setSchemename(DNET_LANGUAGES).build());
        List<String> subjects = DumpToActionsUtility.getArrayValues(rootElement, "subject");
        subjects.forEach(s -> metadata.addSubject(FieldTypeProtos.StructuredProperty.newBuilder().setValue(s).setQualifier(DumpToActionsUtility.getQualifier("keyword", "dnet:subject")).build()));
        List<String> titles = DOIBoostToActions.getCleanedTitles(rootElement);
        titles.forEach(t -> metadata.addTitle(FieldTypeProtos.StructuredProperty.newBuilder().setValue(t).setQualifier(DumpToActionsUtility.getQualifier("main title", "dnet:dataCite_title")).build()));
        DOIBoostToActions.settingRelevantDate(rootElement, metadata, "issued", "issued", true);
        DOIBoostToActions.settingRelevantDate(rootElement, metadata, "accepted", "accepted", false);
        DOIBoostToActions.settingRelevantDate(rootElement, metadata, "published-online", "published-online", false);
        DOIBoostToActions.settingRelevantDate(rootElement, metadata, "published-print", "published-print", false);
        DumpToActionsUtility.getArrayObjects(rootElement, "abstract").forEach(d -> {
            if (MAG.equals(d.get("provenance").getAsString())) {
                metadata.addDescription(FieldTypeProtos.StringField.newBuilder().setValue(DOIBoostToActions.decompressAbstract(d.get("value").getAsString())).build());
            } else {
                metadata.addDescription(FieldTypeProtos.StringField.newBuilder().setValue(d.get("value").getAsString()).build());
            }
        });
        if (StringUtils.isNotBlank((CharSequence)publisher)) {
            FieldTypeProtos.Journal.Builder journal = FieldTypeProtos.Journal.newBuilder().setName(publisher);
            if (DOIBoostToActions.hasJSONArrayField(rootElement, "issn")) {
                StreamUtils.toStream(rootElement.getAsJsonArray("issn").iterator()).map(JsonElement::getAsJsonObject).forEach(it -> {
                    String issntype = DumpToActionsUtility.getStringValue(it, "type");
                    String value = DumpToActionsUtility.getStringValue(it, "value");
                    if ("electronic".equals(issntype)) {
                        journal.setIssnOnline(value);
                    }
                    if ("print".equals(issntype)) {
                        journal.setIssnPrinted(value);
                    }
                });
            }
            metadata.setJournal(journal.build());
        }
        metadata.setResulttype(DumpToActionsUtility.getQualifier(DumpToActionsUtility.getDefaultResulttype(cobjValue), "dnet:result_typologies"));
        result.setMetadata(metadata.build());
        entity.setResult(result.build());
        oaf.setEntity(entity.build());
        ArrayList<AtomicAction> actionList = new ArrayList<AtomicAction>();
        if (!onlyOrganization) {
            actionList.add(factory.createAtomicAction(setName, agent, oaf.getEntity().getId(), "result", "body", oaf.build().toByteArray()));
        }
        if (!((Collection)authorsOrganizations.getValue()).isEmpty()) {
            ((Collection)authorsOrganizations.getValue()).forEach(o -> {
                String gridOrganization;
                actionList.add(factory.createAtomicAction(setName, agent, o.getEntity().getId(), "organization", "body", o.toByteArray()));
                if (!onlyOrganization) {
                    actionList.addAll(DOIBoostToActions.createPublicationOrganizationRelation(oaf.build(), o, factory, setName, agent));
                }
                if ((gridOrganization = DOIBoostToActions.getSimilarGridOrganization(o.getEntity())) != null) {
                    actionList.add(factory.createAtomicAction(setName, agent, o.getEntity().getId(), "organizationOrganization_dedupSimilarity_isSimilarTo", gridOrganization, "".getBytes()));
                    actionList.add(factory.createAtomicAction(setName, agent, gridOrganization, "organizationOrganization_dedupSimilarity_isSimilarTo", o.getEntity().getId(), "".getBytes()));
                }
            });
        }
        return actionList;
    }

    private static String getSimilarGridOrganization(OafProtos.OafEntity organization) {
        List pidList = organization.getPidList();
        if (pidList != null) {
            for (FieldTypeProtos.StructuredProperty p : pidList) {
                if (!p.getQualifier().getClassname().equals("grid")) continue;
                return "20|grid________::" + AbstractDNetXsltFunctions.md5((String)p.getValue());
            }
        }
        return null;
    }

    private static List<AtomicAction> createPublicationOrganizationRelation(OafProtos.Oaf publication, OafProtos.Oaf organization, ActionFactory factory, String setName, Agent agent) {
        ArrayList<AtomicAction> result = new ArrayList<AtomicAction>();
        OafProtos.Oaf.Builder roaf = OafProtos.Oaf.newBuilder();
        roaf.setKind(KindProtos.Kind.relation);
        roaf.setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setInvisible(false).setDeletedbyinference(false).setInferred(false).setTrust("0.9").setProvenanceaction(DumpToActionsUtility.getQualifier("sysimport:actionset", "dnet:provenanceActions")).build());
        OafProtos.OafRel.Builder rel = OafProtos.OafRel.newBuilder();
        rel.setRelType(RelTypeProtos.RelType.resultOrganization);
        rel.setSubRelType(RelTypeProtos.SubRelType.affiliation);
        rel.setSource(publication.getEntity().getId());
        rel.setTarget(organization.getEntity().getId());
        rel.setRelClass(ResultOrganizationProtos.ResultOrganization.Affiliation.RelName.hasAuthorInstitution.toString());
        ResultOrganizationProtos.ResultOrganization.Builder rel_instance = ResultOrganizationProtos.ResultOrganization.newBuilder();
        ResultOrganizationProtos.ResultOrganization.Affiliation.Builder affiliationRel = ResultOrganizationProtos.ResultOrganization.Affiliation.newBuilder();
        affiliationRel.setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DumpToActionsUtility.getQualifier("hasAuthorInstitution", "dnet:result_organization_relations")).build());
        rel_instance.setAffiliation(affiliationRel.build());
        rel.setResultOrganization(rel_instance.build());
        rel.addCollectedfrom(FieldTypeProtos.KeyValue.newBuilder().setValue((String)datasources.get(MAG.toLowerCase()).getKey()).setKey("10|openaire____::" + AbstractDNetXsltFunctions.md5((String)StringUtils.substringAfter((String)((String)datasources.get(MAG.toLowerCase()).getValue()), (String)SEPARATOR))).build());
        rel.setChild(false);
        roaf.setRel(rel.build());
        result.add(factory.createAtomicAction(setName, agent, publication.getEntity().getId(), "resultOrganization_affiliation_hasAuthorInstitution", organization.getEntity().getId(), roaf.build().toByteArray()));
        rel.setTarget(publication.getEntity().getId());
        rel.setSource(organization.getEntity().getId());
        rel.setRelClass(ResultOrganizationProtos.ResultOrganization.Affiliation.RelName.isAuthorInstitutionOf.toString());
        affiliationRel.setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DumpToActionsUtility.getQualifier("isAuthorInstitutionOf", "dnet:result_organization_relations")).build());
        rel_instance.setAffiliation(affiliationRel.build());
        rel.setResultOrganization(rel_instance.build());
        roaf.setRel(rel.build());
        result.add(factory.createAtomicAction(setName, agent, organization.getEntity().getId(), "resultOrganization_affiliation_isAuthorInstitutionOf", publication.getEntity().getId(), roaf.build().toByteArray()));
        return result;
    }

    private static boolean hasJSONArrayField(JsonObject root, String key) {
        return root.has(key) && root.get(key).isJsonArray();
    }

    private static void settingRelevantDate(JsonObject rootElement, ResultProtos.Result.Metadata.Builder metadata, String jsonKey, String dictionaryKey, boolean addToDateOfAcceptance) {
        String date = DumpToActionsUtility.getStringValue(rootElement, jsonKey);
        if (date == null) {
            return;
        }
        if (date.length() == 4) {
            date = date + "-01-01";
        }
        if (DumpToActionsUtility.isValidDate(date)) {
            if (addToDateOfAcceptance) {
                metadata.setDateofacceptance(FieldTypeProtos.StringField.newBuilder().setValue(date).build());
            }
            metadata.addRelevantdate(FieldTypeProtos.StructuredProperty.newBuilder().setValue(date).setQualifier(DumpToActionsUtility.getQualifier(dictionaryKey, "dnet:dataCite_date")).build());
        }
    }

    public static FieldTypeProtos.KeyValue extractIdentifier(String value) {
        FieldTypeProtos.KeyValue.Builder pid = FieldTypeProtos.KeyValue.newBuilder();
        if (StringUtils.contains((CharSequence)value, (CharSequence)"orcid.org")) {
            return pid.setValue(value.replaceAll("https://orcid.org/", "").replaceAll("http://orcid.org/", "")).setKey(ORCID).build();
        }
        if (StringUtils.contains((CharSequence)value, (CharSequence)"academic.microsoft.com/#/detail")) {
            return pid.setValue(value.replaceAll("https://academic.microsoft.com/#/detail/", "")).setKey("MAG Identifier").build();
        }
        return pid.setValue(value).setKey("URL").build();
    }

    public static OafProtos.Oaf createOrganizationFromJSON(JsonObject affiliation) {
        HashMap<String, FieldTypeProtos.Qualifier> affiliationIdentifiers = new HashMap<String, FieldTypeProtos.Qualifier>();
        ArrayList magId = new ArrayList();
        DumpToActionsUtility.getArrayObjects(affiliation, "identifiers").forEach(it -> {
            if (StringUtils.contains((CharSequence)it.get("value").getAsString(), (CharSequence)"academic.microsoft.com")) {
                affiliationIdentifiers.put(it.get("value").getAsString(), affiliationPIDType.get(MAG));
                magId.add(it.get("value").getAsString());
            } else {
                affiliationIdentifiers.put(it.get("value").getAsString(), affiliationPIDType.get(it.get("schema").getAsString()));
            }
        });
        if (magId.size() > 0) {
            String microsoftID = (String)magId.get(0);
            OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
            oaf.setKind(KindProtos.Kind.entity);
            OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder();
            entity.setType(TypeProtos.Type.organization);
            entity.setId("20|microsoft___::" + AbstractDNetXsltFunctions.md5((String)microsoftID));
            String id = (String)datasources.get(affiliation.get("provenance").getAsString().toLowerCase()).getValue();
            String name = (String)datasources.get(affiliation.get("provenance").getAsString().toLowerCase()).getKey();
            if (!StringUtils.isNotBlank((CharSequence)id) || !StringUtils.isNotBlank((CharSequence)name)) {
                return null;
            }
            FieldTypeProtos.KeyValue collectedFrom = FieldTypeProtos.KeyValue.newBuilder().setValue(name).setKey("10|openaire____::" + AbstractDNetXsltFunctions.md5((String)StringUtils.substringAfter((String)id, (String)SEPARATOR))).build();
            entity.addCollectedfrom(collectedFrom);
            entity.addOriginalId(microsoftID);
            affiliationIdentifiers.forEach((key, value) -> entity.addPid(FieldTypeProtos.StructuredProperty.newBuilder().setQualifier(value).setValue(key).build()));
            OrganizationProtos.Organization.Builder organization = OrganizationProtos.Organization.newBuilder();
            organization.setMetadata(OrganizationProtos.Organization.Metadata.newBuilder().setWebsiteurl(FieldTypeProtos.StringField.newBuilder().setValue(affiliation.get("official-page").getAsString()).build()).setLegalname(FieldTypeProtos.StringField.newBuilder().setValue(affiliation.get("value").getAsString()).build()).build());
            entity.setOrganization(organization);
            oaf.setEntity(entity);
            oaf.setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setInvisible(false).setDeletedbyinference(false).setInferred(false).setTrust("0.9").setProvenanceaction(DumpToActionsUtility.getQualifier("sysimport:actionset", "dnet:provenanceActions")).build());
            return oaf.build();
        }
        return null;
    }

    public static Pair<List<FieldTypeProtos.Author>, Collection<OafProtos.Oaf>> createAuthorsOrganization(JsonObject root) {
        HashMap affiliations = new HashMap();
        List<JsonObject> authors = DumpToActionsUtility.getArrayObjects(root, "authors");
        AtomicInteger counter = new AtomicInteger(1);
        List collect = authors.stream().map(author -> {
            String given = DumpToActionsUtility.getStringValue(author, "given");
            String family = DumpToActionsUtility.getStringValue(author, "family");
            String fullname = DumpToActionsUtility.getStringValue(author, "fullname");
            if (StringUtils.isBlank((CharSequence)fullname) && StringUtils.isNotBlank((CharSequence)given) && StringUtils.isNotBlank((CharSequence)family)) {
                fullname = String.format("%s %s", given, family);
            }
            if (!DOIBoostToActions.isValidAuthorName(fullname, null)) {
                return null;
            }
            FieldTypeProtos.Author.Builder abuilder = FieldTypeProtos.Author.newBuilder();
            if (StringUtils.isNotBlank((CharSequence)given)) {
                abuilder.setName(given);
            }
            if (StringUtils.isNotBlank((CharSequence)family)) {
                abuilder.setSurname(family);
            }
            if (StringUtils.isNotBlank((CharSequence)fullname)) {
                abuilder.setFullname(fullname);
            }
            List<JsonObject> identifiers = DumpToActionsUtility.getArrayObjects(author, "identifiers");
            List<JsonObject> authorAffiliation = DumpToActionsUtility.getArrayObjects(author, "affiliations");
            authorAffiliation.forEach(it -> {
                OafProtos.Oaf org = DOIBoostToActions.createOrganizationFromJSON(it);
                if (org != null) {
                    affiliations.put(org.getEntity().getId(), org);
                    abuilder.addAffiliation(org.getEntity().getOrganization().getMetadata().getLegalname());
                }
            });
            identifiers.stream().map(id -> {
                String value = id.get("value").getAsString();
                return DOIBoostToActions.extractIdentifier(value);
            }).collect(Collectors.toMap(FieldTypeProtos.KeyValue::getKey, Function.identity(), (a, b) -> a)).values().forEach(arg_0 -> ((FieldTypeProtos.Author.Builder)abuilder).addPid(arg_0));
            abuilder.setRank(counter.getAndIncrement());
            return abuilder.build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return new Pair(collect, affiliations.values());
    }

    static {
        try {
            InputStream is = DOIBoostToActions.class.getResourceAsStream("/eu/dnetlib/data/mapreduce/hbase/dataimport/mapping_typologies.json");
            String tt = IOUtils.toString((InputStream)is);
            typologiesMapping = (Map)new Gson().fromJson(tt, Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

