/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.mapreduce.hbase.dataexport.OpenaireEntityId;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ExportResultIdentifiersMapper
extends TableMapper<Text, Text> {
    private static final Log log = LogFactory.getLog(ExportResultIdentifiersMapper.class);
    private static final String CF = "result";
    private Text keyOut;
    private Text valueOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text("");
        this.valueOut = new Text();
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            byte[] body = value.getValue(Bytes.toBytes((String)CF), DedupUtils.BODY_B);
            if (body == null) {
                context.getCounter(CF, "missing body").increment(1L);
                return;
            }
            OpenaireEntityId id = new OpenaireEntityId();
            OafDecoder d = OafDecoder.decode((byte[])body);
            id.setDeleted(d.getOaf().getDataInfo().getDeletedbyinference());
            id.setId(d.getEntityId());
            id.setPids(d.getOaf().getEntity().getPidList().stream().collect(Collectors.groupingBy(p -> p.getQualifier().getClassid())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(FieldTypeProtos.StructuredProperty::getValue).collect(Collectors.toList()))));
            List childrenList = d.getEntity().getChildrenList();
            if (childrenList != null && !childrenList.isEmpty()) {
                ArrayList mergedIds = Lists.newArrayList((Iterable)Iterables.transform((Iterable)childrenList, oafEntity -> oafEntity.getId()));
                Collections.sort(mergedIds);
                id.setMergedIds(mergedIds);
            }
            this.valueOut.set(id.toString());
            context.write((Object)this.keyOut, (Object)this.valueOut);
        }
        catch (Throwable e2) {
            log.error((Object)("error exporting the following record from HBase: " + value.toString()), e2);
            context.getCounter("error", e2.getClass().getName()).increment(1L);
            throw new RuntimeException(e2);
        }
    }
}

