/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.communitytoresult;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class CommunityToResultFileReducer
extends Reducer<ImmutableBytesWritable, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(CommunityToResultFileReducer.class);
    private Text keyOut;
    private Text outValue;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text("");
        this.outValue = new Text();
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        Iterator<Text> it = values.iterator();
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        while (it.hasNext()) {
            Value v = Value.fromJson(it.next().toString());
            metadata.addContext(Utils.getContext(v.getValue(), v.getTrust()));
        }
        this.keyOut.set(Bytes.toBytes((String)key.toString()));
        this.outValue.set(JsonFormat.printToString((Message)Utils.getUpdate(metadata, key.toString())).getBytes());
        context.write((Object)this.keyOut, (Object)this.outValue);
    }
}

