/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;

public class OAVersionEventFactory {
    public static final String OPEN = "OPEN";

    public static List<EventWrapper> process(OafProtos.Oaf current, OafProtos.Oaf other, float trust, Set<String> untrustedOaDsList) throws IOException, InterruptedException, DocumentException {
        return new OAVersionEventFactory().processOAVersion(current, other, trust, untrustedOaDsList);
    }

    private List<EventWrapper> processOAVersion(OafProtos.Oaf current, OafProtos.Oaf other, float trust, Set<String> untrustedOaDsList) throws IOException, InterruptedException, DocumentException {
        ArrayList events = Lists.newArrayList();
        String otherDsId = StringUtils.substringAfter((String)OafHbaseUtils.getKey(other.getEntity().getCollectedfromList()), (String)"|");
        if (!untrustedOaDsList.contains(otherDsId) && this.hasAccess(other, OPEN, false)) {
            events.add(this.doProcessOAVersion(current, other, Topic.ENRICH_MORE_OA_VERSION, trust));
            if (!this.hasAccess(current, OPEN, true)) {
                events.add(this.doProcessOAVersion(current, other, Topic.ENRICH_MISSING_OA_VERSION, trust));
            }
        }
        return events;
    }

    private EventWrapper doProcessOAVersion(OafProtos.Oaf current, OafProtos.Oaf other, Topic topic, float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        Map instances = other.getEntity().getResult().getInstanceList().stream().filter(i -> OPEN.equalsIgnoreCase(i.getAccessright().getClassid())).filter(i -> i.getUrlList() != null && !i.getUrlList().isEmpty()).collect(Collectors.toMap(i -> {
            List url = i.getUrlList();
            return StringUtils.lowerCase((String)((String)url.get(0)));
        }, Function.identity(), (i1, i2) -> i1));
        prototype.getEntityBuilder().getResultBuilder().addAllInstance(instances.values());
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichOa(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), instances.values());
        return EventWrapper.newInstance(EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust), payload.getHighlight().getInstances().stream().filter(Objects::nonNull).map(i -> i.getLicense() + ":" + i.getUrl()).sorted().collect(Collectors.joining(", ")), topic.getValue());
    }

    private boolean hasAccess(OafProtos.Oaf oaf, String access, boolean strict) {
        Predicate p = i -> access.equalsIgnoreCase(i.getAccessright().getClassid());
        List i2 = oaf.getEntity().getResult().getInstanceList();
        return strict ? Iterables.all((Iterable)i2, (Predicate)p) : Iterables.any((Iterable)i2, (Predicate)p);
    }
}

