/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PrepareBrokerDataReducer
extends Reducer<Text, ImmutableBytesWritable, Text, Text> {
    private Text outKey;
    private Text outValue;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.outKey = new Text("");
        this.outValue = new Text();
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode((String)key.toString());
        if (!keyDecoder.getType().equals((Object)TypeProtos.Type.result)) {
            return;
        }
        try {
            boolean entity = false;
            OafProtos.Oaf.Builder out = OafProtos.Oaf.newBuilder();
            for (OafProtos.Oaf oaf : OafHbaseUtils.asOaf(values)) {
                if (KindProtos.Kind.entity.equals((Object)oaf.getKind())) {
                    if (entity) {
                        context.getCounter("result", "skipped group > 1").increment(1L);
                        return;
                    }
                    String resulttypeid = oaf.getEntity().getResult().getMetadata().getResulttype().getClassid();
                    if (!"publication".equals(resulttypeid)) {
                        context.getCounter("result", "skipped " + resulttypeid).increment(1L);
                        return;
                    }
                    out.mergeFrom(oaf);
                    entity = true;
                    continue;
                }
                out.getEntityBuilder().addCachedRel(oaf.getRel());
            }
            this.outValue.set(JsonFormat.printToString((Message)out.build()));
            context.write((Object)this.outKey, (Object)this.outValue);
        }
        catch (Exception e) {
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }
}

