/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public final class Utils {
    public static OafProtos.OafEntity getEntity(Result value, TypeProtos.Type type) throws InvalidProtocolBufferException {
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)type.toString()));
        byte[] body = (byte[])map.get(Bytes.toBytes((String)"body"));
        if (body != null) {
            OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])body);
            if (oaf.getDataInfo().getDeletedbyinference()) {
                return null;
            }
            return oaf.getEntity();
        }
        return null;
    }

    public static FieldTypeProtos.DataInfo.Builder getDataInfo(String trust, String class_id, String schema_id, String schema_name, String data_info_type, String class_name) {
        FieldTypeProtos.DataInfo.Builder builder = FieldTypeProtos.DataInfo.newBuilder().setInferred(true).setProvenanceaction(Utils.getQualifier(class_id, schema_id, schema_name, class_name)).setInferenceprovenance(data_info_type).setTrust(trust);
        return builder;
    }

    public static FieldTypeProtos.Qualifier.Builder getQualifier(String class_id, String schema_id, String schema_name, String class_name) {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(class_id).setClassname(class_name).setSchemeid(schema_id).setSchemename(schema_name);
    }

    public static FieldTypeProtos.Qualifier.Builder getCountry(String countryValue, String trust, String dnet_schema, String class_id, String schema_id, String schema_name, String data_info_type, String class_name) {
        FieldTypeProtos.Qualifier.Builder country = FieldTypeProtos.Qualifier.newBuilder().setClassid(countryValue).setClassname(countryValue).setSchemeid(dnet_schema).setSchemename(dnet_schema);
        country.setDataInfo(Utils.getDataInfo(trust, class_id, schema_id, schema_name, data_info_type, class_name));
        return country;
    }

    public static ResultProtos.Result.Context getContext(String contextid, String trust) {
        ResultProtos.Result.Context.Builder cBuilder = ResultProtos.Result.Context.newBuilder().setId(contextid).addDataInfo(Utils.getDataInfo(trust, "propagation:community:semrel", "dnet:provenanceActions", "dnet:provenanceActions", "propagation", "propagation"));
        return cBuilder.build();
    }

    public static Set<String> getRelationTarget(Result value, String sem_rel, Mapper.Context context, String counter) throws InvalidProtocolBufferException {
        NavigableMap relationMap = value.getFamilyMap(Bytes.toBytes((String)sem_rel));
        context.getCounter(counter, sem_rel).increment((long)relationMap.size());
        return relationMap.values().stream().map(b -> Utils.asOaf(b)).filter(Objects::nonNull).filter(o -> Utils.isValid(o)).filter(o -> !o.getDataInfo().getDeletedbyinference()).map(o -> o.getRel().getTarget()).collect(Collectors.toCollection(HashSet::new));
    }

    private static OafProtos.Oaf asOaf(byte[] r) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])r);
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    public static OafProtos.Oaf getUpdate(ResultProtos.Result.Metadata.Builder metadata, String resultId) {
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder().setMetadata(metadata);
        OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result).setId(resultId).setResult(result);
        return OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.entity).setEntity(entity).build();
    }

    private static boolean isValid(OafProtos.Oaf oaf) {
        return oaf != null && oaf.isInitialized();
    }
}

