/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult;

import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;

public class ResultProjectIterator
extends ResultIterator {
    private Iterator<String> pli;
    private static final String MSG = "Propagation of relation to project through semantic relation among results";

    public ResultProjectIterator(Iterable<Text> values, String key) throws NotValidResultSequenceException {
        super(values, key);
    }

    @Override
    protected void checkSequence() throws NotValidResultSequenceException {
        if (!this.it.hasNext()) {
            throw new NotValidResultSequenceException("Empty information for key");
        }
        this.pli = this.loadProjectList().iterator();
        this.getNext();
    }

    private void getNext() {
        this.resultId = this.pli.hasNext() ? this.pli.next() : "FINITO";
    }

    private Set<String> loadProjectList() throws NotValidResultSequenceException {
        HashSet<String> fromResult = new HashSet<String>();
        HashSet<String> fromSemRel = new HashSet<String>();
        while (this.it.hasNext()) {
            Value v = Value.fromJson(((Text)this.it.next()).toString());
            if (this.trust == null) {
                this.trust = v.getTrust();
            }
            switch (v.getType()) {
                case fromsemrel: {
                    fromSemRel.addAll(Arrays.asList(StringUtils.split((String)v.getValue(), (String)",")));
                    break;
                }
                case fromresult: {
                    if (!StringUtils.isNotBlank((CharSequence)v.getValue())) break;
                    fromResult.addAll(Arrays.asList(StringUtils.split((String)v.getValue(), (String)",")));
                    break;
                }
                case valid: 
                case notvalid: {
                    throw new NotValidResultSequenceException("invalid type of result: " + (Object)((Object)v.getType()));
                }
            }
        }
        return Sets.difference(fromSemRel, fromResult);
    }

    @Override
    public List<OafProtos.Oaf> next() {
        ArrayList<OafProtos.Oaf> ret = new ArrayList<OafProtos.Oaf>(Arrays.asList(this.getOafRel(this.keyb, this.resultId, "isProducedBy"), this.getOafRel(this.resultId, this.keyb, "produces")));
        this.getNext();
        return ret;
    }

    private OafProtos.Oaf getOafRel(String source, String target, String semantics) {
        ResultProjectProtos.ResultProject.Builder rpb = ResultProjectProtos.ResultProject.newBuilder().setOutcome(ResultProjectProtos.ResultProject.Outcome.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(Utils.getQualifier(semantics, semantics, "dnet:result_project_relations", "dnet:result_project_relations"))));
        OafProtos.OafRel.Builder relation = OafProtos.OafRel.newBuilder().setChild(false).setSubRelType(PropagationConstants.SUBREL_TYPE).setRelType(PropagationConstants.REL_TYPE).setRelClass(semantics).setTarget(target).setSource(source).setResultProject(rpb);
        return OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation).setRel(relation).setDataInfo(Utils.getDataInfo(this.trust, "propagation:project:semrel", "dnet:provenanceActions", "dnet:provenanceActions", "propagation", MSG)).build();
    }
}

