/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.hbase.dataimport.OrcidToActions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class OrcidImportMapper
extends Mapper<LongWritable, Text, Text, Text> {
    private String setName;
    private Agent agent;
    private Text keyout;
    private Text valueOut;
    private JsonParser parser;
    private ActionFactory factory;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.setName = context.getConfiguration().get("setName");
        this.agent = new Agent(context.getConfiguration().get("agentId"), context.getConfiguration().get("agentName"), Agent.AGENT_TYPE.service);
        this.keyout = new Text("");
        this.valueOut = new Text("");
        this.factory = new ActionFactory();
        this.parser = new JsonParser();
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String inputJson = value.toString();
        JsonObject rootElement = this.parser.parse(inputJson).getAsJsonObject();
        try {
            context.getCounter(((Object)((Object)this)).getClass().getSimpleName(), "total").increment(1L);
            List<AtomicAction> atomicActions = OrcidToActions.generatePublicationActionsFromDump(rootElement, this.factory, this.setName, this.agent, (counterGroup, counterName, delta) -> context.getCounter(counterGroup, counterName).increment(delta));
            if (atomicActions != null) {
                for (AtomicAction action : atomicActions) {
                    this.keyout.set(action.getRowKey());
                    this.valueOut.set(action.toJSON());
                    context.write((Object)this.keyout, (Object)this.valueOut);
                    context.getCounter(((Object)((Object)this)).getClass().getSimpleName(), action.getTargetColumnFamily()).increment(1L);
                }
                context.getCounter(((Object)((Object)this)).getClass().getSimpleName(), "generated").increment(1L);
            } else {
                context.getCounter(((Object)((Object)this)).getClass().getSimpleName(), "skipped").increment(1L);
            }
        }
        catch (Throwable e) {
            System.err.println(inputJson);
            throw e;
        }
    }
}

