/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class SemanticRelationCounter
extends TableMapper<ImmutableBytesWritable, Writable> {
    private String[] sem_rels;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String[] default_set = new String[]{"resultResult_supplement_isSupplementedBy"};
        this.sem_rels = context.getConfiguration().getStrings("propagatetoproject.semanticrelations", default_set);
        if (this.sem_rels.length == 0) {
            throw new InterruptedException("No semantic relation over which propagate is specified");
        }
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        NavigableMap resultMap = value.getFamilyMap(Bytes.toBytes((String)"result"));
        byte[] body = (byte[])resultMap.get(Bytes.toBytes((String)"body"));
        if (body != null) {
            OafProtos.Oaf res_oaf = OafProtos.Oaf.parseFrom((byte[])body);
            if (res_oaf.getDataInfo().getDeletedbyinference()) {
                context.getCounter("Relation counter", "del by inference result").increment(1L);
                return;
            }
            context.getCounter("Relation counter", "not null body ").increment(1L);
            boolean foundRelation = false;
            for (String sem_rel : this.sem_rels) {
                foundRelation = foundRelation || this.countRelation(sem_rel, context, value);
            }
            if (this.countRelation("resultProject_outcome_isProducedBy", context, value) && foundRelation) {
                context.getCounter("Relation counter", "Association to project in result with semantic relation").increment(1L);
            }
        }
    }

    private boolean countRelation(String rel_to_find, Mapper.Context context, Result value) throws InvalidProtocolBufferException {
        NavigableMap relationMap = value.getFamilyMap(Bytes.toBytes((String)rel_to_find));
        boolean ret = false;
        for (byte[] relation : relationMap.values()) {
            OafProtos.Oaf rel_oaf = OafProtos.Oaf.parseFrom((byte[])relation);
            if (!this.isValid(rel_oaf)) {
                context.getCounter("Relation counter", rel_to_find + " not present in relation set").increment(1L);
                return ret;
            }
            if (rel_oaf.getDataInfo().getDeletedbyinference()) {
                context.getCounter("Relation counter ", rel_to_find + " del by inference").increment(1L);
                continue;
            }
            context.getCounter("Relation counter ", rel_to_find).increment(1L);
            ret = true;
        }
        return ret;
    }

    private boolean isValid(OafProtos.Oaf oaf) {
        return oaf != null && oaf.isInitialized();
    }
}

