/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.pace.distance.algo.JaroWinkler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OrcidEventFactory {
    private static final long MAX_AUTHORS = 50L;
    private static final Float t = Float.valueOf(0.9f);
    public static final String ORCID_TYPE_MARKER = "ORCID";

    public static List<EventWrapper> process(OafProtos.Oaf current, OafProtos.Oaf other, float trust) {
        return new OrcidEventFactory().processOrcid(current, other, trust);
    }

    public List<EventWrapper> processOrcid(OafProtos.Oaf current, OafProtos.Oaf other, float trust) {
        ArrayList events = Lists.newArrayList();
        LinkedList<FieldTypeProtos.Author> currAuthors = this.getAuthors(current, this.noneIsORCID());
        LinkedList<FieldTypeProtos.Author> otherAuthors = this.getAuthors(other, this.anyIsORCID());
        while (!currAuthors.isEmpty()) {
            FieldTypeProtos.Author currentAuthor = (FieldTypeProtos.Author)currAuthors.remove();
            Pair bestMatch = null;
            for (FieldTypeProtos.Author otherAuthor : otherAuthors) {
                Pair pair = new Pair((Object)otherAuthor, (Object)this.distance(currentAuthor, otherAuthor));
                if (bestMatch != null && !(((Float)pair.getValue()).floatValue() > ((Float)bestMatch.getValue()).floatValue())) continue;
                bestMatch = pair;
            }
            if (bestMatch == null || !(((Float)bestMatch.getValue()).floatValue() >= t.floatValue())) continue;
            float authorTrust = trust * ((Float)bestMatch.getValue()).floatValue();
            events.add(this.doProcessOrcid(current, other, (Pair<FieldTypeProtos.Author, FieldTypeProtos.Author>)new Pair((Object)currentAuthor, bestMatch.getKey()), Topic.ENRICH_MISSING_AUTHOR_ORCID, authorTrust));
        }
        return events;
    }

    private LinkedList<FieldTypeProtos.Author> getAuthors(OafProtos.Oaf oaf, Predicate<FieldTypeProtos.Author> p) {
        return this.authors(oaf).stream().filter(p).limit(50L).collect(Collectors.toCollection(LinkedList::new));
    }

    private Predicate<FieldTypeProtos.Author> anyIsORCID() {
        return author -> author.getPidList().stream().anyMatch(pid -> ORCID_TYPE_MARKER.equals(pid.getKey()));
    }

    private Predicate<FieldTypeProtos.Author> noneIsORCID() {
        return author -> author.getPidList().stream().noneMatch(pid -> ORCID_TYPE_MARKER.equals(pid.getKey()));
    }

    private EventWrapper doProcessOrcid(OafProtos.Oaf current, OafProtos.Oaf other, Pair<FieldTypeProtos.Author, FieldTypeProtos.Author> pair, Topic topic, float trust) {
        OafProtos.Oaf.Builder prototype = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        for (FieldTypeProtos.Author.Builder a : prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().getAuthorBuilderList()) {
            if (!a.getFullname().equals(((FieldTypeProtos.Author)pair.getKey()).getFullname())) continue;
            a.addAllPid((Iterable)((FieldTypeProtos.Author)pair.getValue()).getPidList().stream().filter(p -> ORCID_TYPE_MARKER.equals(p.getKey())).collect(Collectors.toList()));
        }
        OafProtos.Oaf oaf = prototype.build();
        OpenAireEventPayload payload = HighlightFactory.highlightEnrichOrcidAuthor(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), (FieldTypeProtos.Author)pair.getValue());
        return EventWrapper.newInstance(EventFactory.asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust), payload.getHighlight().getCreators().stream().filter(s -> StringUtils.contains((CharSequence)s, (CharSequence)ORCID_TYPE_MARKER)).collect(Collectors.joining(", ")), topic.getValue());
    }

    private List<FieldTypeProtos.Author> authors(OafProtos.Oaf oaf) {
        List authors = oaf.getEntity().getResult().getMetadata().getAuthorList();
        if (authors == null) {
            return Lists.newLinkedList();
        }
        return authors;
    }

    private Float distance(FieldTypeProtos.Author a, FieldTypeProtos.Author b) {
        JaroWinkler jaroWinkler = new JaroWinkler(1.0);
        if (a.hasSurname() && b.hasSurname()) {
            return Float.valueOf((float)jaroWinkler.distance(this.getCanonicalName(a), this.getCanonicalName(b)));
        }
        return Float.valueOf((float)jaroWinkler.distance(a.getFullname(), b.getFullname()));
    }

    private String getCanonicalName(FieldTypeProtos.Author a) {
        return (StringUtils.substring((String)a.getName(), (int)0, (int)1) + a.getSurname()).toLowerCase();
    }
}

