package eu.dnetlib.data.mapreduce.hbase.index;

import eu.dnetlib.data.proto.TypeProtos;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CountXmlRecordsMapper extends Mapper<Text, Text, NullWritable, NullWritable> {

	private static final Log log = LogFactory.getLog(CountXmlRecordsMapper.class); // NOPMD by marko on 11/24/08 5:02 PM

	private SAXReader saxReader;

	@Override
	protected void setup(final Context context) throws IOException, InterruptedException {
		super.setup(context);

		saxReader = new SAXReader();
	}

	@Override
	protected void map(final Text key, final Text value, final Context context) throws IOException, InterruptedException {
		try {

			final Document doc = saxReader.read(new StringReader(value.toString()));

			final Boolean deleted = Boolean.valueOf(doc.valueOf("//*[local-name()='entity']//datainfo/deletedbyinference"));
			final String oaftype = doc.valueOf("local-name(//*[local-name()='entity']/*)");

			context.getCounter(oaftype, String.format("%s deleted %s", oaftype, deleted)).increment(1);

			if (TypeProtos.Type.result.toString().equals(oaftype)) {

				final String resulttypeid = doc.valueOf("//*[local-name()='entity']/*[local-name()='result']/resulttype/@classid");
				context.getCounter(oaftype, String.format("%s deleted %s", resulttypeid, deleted)).increment(1);

			}

		} catch (final Throwable e) {
			//log.error("error parsing record\n" + value.toString(), e);

			context.getCounter("error", e.getClass().getName()).increment(1);
		}
	}

}
