/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.mapreduce.hbase.Reporter;
import eu.dnetlib.data.mapreduce.hbase.dataimport.DumpToActionsUtility;
import eu.dnetlib.data.mapreduce.util.StreamUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.pace.model.Person;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class OrcidToActions {
    public static final String ORCID = "ORCID";
    public static final String orcidPREFIX = "orcid_______";
    public static final String OPENAIRE_PREFIX = "openaire____";
    public static final String SEPARATOR = "::";
    private static Map<String, Pair<String, String>> datasources = new HashMap<String, Pair<String, String>>(){
        {
            this.put(OrcidToActions.ORCID.toLowerCase(), new Pair((Object)OrcidToActions.ORCID, (Object)"openaire____::orcid"));
        }
    };
    private static Map<String, Pair<String, String>> externalIds = new HashMap<String, Pair<String, String>>(){
        {
            this.put("ark".toLowerCase(), new Pair((Object)"ark", (Object)"ark"));
            this.put("arxiv".toLowerCase(), new Pair((Object)"arxiv", (Object)"arXiv"));
            this.put("pmc".toLowerCase(), new Pair((Object)"pmc", (Object)"pmc"));
            this.put("pmid".toLowerCase(), new Pair((Object)"pmid", (Object)"pmid"));
            this.put("source-work-id".toLowerCase(), new Pair((Object)"orcidworkid", (Object)"orcidworkid"));
            this.put("urn".toLowerCase(), new Pair((Object)"urn", (Object)"urn"));
        }
    };
    static Map<String, Map<String, String>> typologiesMapping;
    public static final String PID_TYPES = "dnet:pid_types";

    public static List<AtomicAction> generatePublicationActionsFromDump(JsonObject rootElement, ActionFactory factory, String setName, Agent agent, Reporter context) {
        ResultProtos.Result.Instance.Builder instance;
        String typeValue;
        String title;
        if (!OrcidToActions.isValid(rootElement, context)) {
            return null;
        }
        OafProtos.Oaf.Builder oaf = OafProtos.Oaf.newBuilder();
        oaf.setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setDeletedbyinference(false).setInferred(false).setTrust("0.9").setProvenanceaction(DumpToActionsUtility.getQualifier("sysimport:actionset:orcidworks-no-doi", "dnet:provenanceActions")).build());
        oaf.setKind(KindProtos.Kind.entity);
        oaf.setLastupdatetimestamp(DateUtils.now());
        OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result);
        entity.setDateofcollection("2018-10-22");
        entity.setDateoftransformation(DateUtils.now_ISO8601());
        StreamUtils.toStream(externalIds.keySet().iterator()).forEach(jsonExtId -> {
            String classid = (String)externalIds.get(jsonExtId.toLowerCase()).getValue();
            String classname = (String)externalIds.get(jsonExtId.toLowerCase()).getKey();
            String extId = DumpToActionsUtility.getStringValue(rootElement, jsonExtId);
            if (StringUtils.isNotBlank((CharSequence)extId)) {
                entity.addPid(FieldTypeProtos.StructuredProperty.newBuilder().setValue(extId).setQualifier(FieldTypeProtos.Qualifier.newBuilder().setClassid(classid).setClassname(classname).setSchemeid(PID_TYPES).setSchemename(PID_TYPES).build()).build());
            }
        });
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        String source = DumpToActionsUtility.getStringValue(rootElement, "source");
        if (StringUtils.isNotBlank((CharSequence)source)) {
            metadata.addSource(FieldTypeProtos.StringField.newBuilder().setValue(source).build());
        }
        if (StringUtils.isBlank((CharSequence)(title = OrcidToActions.createRepeatedField(rootElement, "titles")))) {
            context.incrementCounter("filtered", "title_not_found", 1L);
            return null;
        }
        metadata.addTitle(FieldTypeProtos.StructuredProperty.newBuilder().setValue(title).setQualifier(DumpToActionsUtility.getQualifier("main title", "dnet:dataCite_title")).build());
        String id = DumpToActionsUtility.getStringValue(rootElement, "id");
        String sourceId = null;
        if (id != null) {
            entity.addOriginalId(id);
            sourceId = String.format("50|%s::%s", orcidPREFIX, AbstractDNetXsltFunctions.md5((String)id));
        } else {
            sourceId = String.format("50|%s::%s", orcidPREFIX, AbstractDNetXsltFunctions.md5((String)title));
        }
        entity.setId(sourceId);
        OrcidToActions.settingRelevantDate(rootElement, metadata, "publication_date", "issued", true);
        FieldTypeProtos.KeyValue collectedFrom = FieldTypeProtos.KeyValue.newBuilder().setValue(ORCID).setKey("10|openaire____::806360c771262b4d6770e7cdf04b5c5a").build();
        entity.addCollectedfrom(collectedFrom);
        String type = DumpToActionsUtility.getStringValue(rootElement, "type");
        String cobjValue = "";
        if (StringUtils.isNotBlank((CharSequence)type)) {
            metadata.setResourcetype(FieldTypeProtos.Qualifier.newBuilder().setClassid(type).setClassname(type).setSchemeid("dnet:dataCite_resource").setSchemename("dnet:dataCite_resource").build());
            typeValue = typologiesMapping.get(type).get("value");
            cobjValue = typologiesMapping.get(type).get("cobj");
            instance = ResultProtos.Result.Instance.newBuilder();
            instance.setHostedby(FieldTypeProtos.KeyValue.newBuilder().setKey("10|openaire____::55045bd2a65019fd8e6741a755395c8c").setValue("Unknown Repository").build());
            String url = OrcidToActions.createRepeatedField(rootElement, "urls");
            if (StringUtils.isNotBlank((CharSequence)url)) {
                instance.addUrl(url);
            } else {
                OrcidToActions.setAsInvisible(oaf);
                context.incrementCounter("total", "invisible", 1L);
            }
            String pubDate = OrcidToActions.getPublicationDate(rootElement, "publication_date");
            if (StringUtils.isNotBlank((CharSequence)pubDate)) {
                instance.setDateofacceptance(FieldTypeProtos.StringField.newBuilder().setValue(pubDate).build());
            }
        } else {
            context.incrementCounter("filtered", "type_not_found", 1L);
            return null;
        }
        instance.setCollectedfrom(collectedFrom);
        instance.setAccessright(FieldTypeProtos.Qualifier.newBuilder().setClassid("UNKNOWN").setClassname("UNKNOWN").setSchemeid("dnet:access_modes").setSchemename("dnet:access_modes").build());
        instance.setInstancetype(FieldTypeProtos.Qualifier.newBuilder().setClassid(cobjValue).setClassname(typeValue).setSchemeid("dnet:publication_resource").setSchemename("dnet:publication_resource").build());
        result.addInstance(instance);
        List<FieldTypeProtos.Author> authors = OrcidToActions.createAuthors(rootElement);
        if (authors == null || authors.size() <= 0) {
            context.incrementCounter("filtered", "author_not_found", 1L);
            return null;
        }
        metadata.addAllAuthor(authors);
        metadata.setResulttype(DumpToActionsUtility.getQualifier(DumpToActionsUtility.getDefaultResulttype(cobjValue), "dnet:result_typologies"));
        result.setMetadata(metadata.build());
        entity.setResult(result.build());
        oaf.setEntity(entity.build());
        ArrayList<AtomicAction> actionList = new ArrayList<AtomicAction>();
        actionList.add(factory.createAtomicAction(setName, agent, oaf.getEntity().getId(), "result", "body", oaf.build().toByteArray()));
        return actionList;
    }

    public static void setAsInvisible(OafProtos.Oaf.Builder oaf) {
        oaf.setDataInfo(FieldTypeProtos.DataInfo.newBuilder().setInvisible(true).setDeletedbyinference(false).setInferred(false).setTrust("0.9").setProvenanceaction(DumpToActionsUtility.getQualifier("sysimport:actionset:orcidworks-no-doi", "dnet:provenanceActions")).build());
    }

    public static List<FieldTypeProtos.Author> createAuthors(JsonObject root) {
        String authorsJSONFieldName = "authors";
        if (root.has("authors") && root.get("authors").isJsonArray()) {
            ArrayList<FieldTypeProtos.Author> authors = new ArrayList<FieldTypeProtos.Author>();
            JsonArray jsonAuthors = root.getAsJsonArray("authors");
            int firstCounter = 0;
            int defaultCounter = 0;
            int rank = 1;
            int currentRank = 0;
            for (JsonElement item : jsonAuthors) {
                JsonObject author = item.getAsJsonObject();
                FieldTypeProtos.Author.Builder result = FieldTypeProtos.Author.newBuilder();
                if (item.isJsonObject()) {
                    String surname = DumpToActionsUtility.getStringValue(author, "surname");
                    String name = DumpToActionsUtility.getStringValue(author, "name");
                    String oid = DumpToActionsUtility.getStringValue(author, "oid");
                    String seq = DumpToActionsUtility.getStringValue(author, "seq");
                    if (StringUtils.isNotBlank((CharSequence)seq)) {
                        rank = seq.equals("first") ? ++firstCounter : (seq.equals("additional") ? currentRank + 1 : ++defaultCounter);
                    }
                    if (StringUtils.isNotBlank((CharSequence)oid)) {
                        result.addPid(FieldTypeProtos.KeyValue.newBuilder().setValue(oid).setKey(ORCID).build());
                        result.setFullname(name + " " + surname);
                        if (StringUtils.isNotBlank((CharSequence)name)) {
                            result.setName(name);
                        }
                        if (StringUtils.isNotBlank((CharSequence)surname)) {
                            result.setSurname(surname);
                        }
                    } else {
                        String fullname = "";
                        if (StringUtils.isNotBlank((CharSequence)name)) {
                            fullname = name;
                        } else if (StringUtils.isNotBlank((CharSequence)surname)) {
                            fullname = surname;
                        }
                        Person p = new Person(fullname, false);
                        if (p.isAccurate()) {
                            result.setName(p.getNormalisedFirstName());
                            result.setSurname(p.getNormalisedSurname());
                            result.setFullname(p.getNormalisedFullname());
                        } else {
                            result.setFullname(fullname);
                        }
                    }
                }
                result.setRank(rank);
                authors.add(result.build());
                currentRank = rank;
            }
            return authors;
        }
        return null;
    }

    private static String createRepeatedField(JsonObject rootElement, String fieldName) {
        String field = "";
        if (!rootElement.has(fieldName)) {
            return null;
        }
        if (rootElement.has(fieldName) && rootElement.get(fieldName).isJsonNull()) {
            return null;
        }
        if (rootElement.get(fieldName).isJsonArray()) {
            if (!OrcidToActions.isValidJsonArray(rootElement, fieldName)) {
                return null;
            }
            StringBuilder ttl = new StringBuilder();
            DumpToActionsUtility.getArrayValues(rootElement, fieldName).forEach(ttl::append);
            field = ttl.toString();
        } else {
            field = DumpToActionsUtility.getStringValue(rootElement, fieldName);
        }
        if (StringUtils.isNotBlank((CharSequence)field) && field.charAt(0) == '\"' && field.charAt(field.length() - 1) == '\"') {
            field = StringUtils.strip((String)field, (String)"\"");
        }
        return field;
    }

    private static void settingRelevantDate(JsonObject rootElement, ResultProtos.Result.Metadata.Builder metadata, String jsonKey, String dictionaryKey, boolean addToDateOfAcceptance) {
        String pubDate = OrcidToActions.getPublicationDate(rootElement, "publication_date");
        if (StringUtils.isNotBlank((CharSequence)pubDate)) {
            if (addToDateOfAcceptance) {
                metadata.setDateofacceptance(FieldTypeProtos.StringField.newBuilder().setValue(pubDate).build());
            }
            metadata.addRelevantdate(FieldTypeProtos.StructuredProperty.newBuilder().setValue(pubDate).setQualifier(DumpToActionsUtility.getQualifier(dictionaryKey, "dnet:dataCite_date")).build());
        }
    }

    private static String getPublicationDate(JsonObject rootElement, String jsonKey) {
        JsonObject pubDateJson = rootElement.getAsJsonObject(jsonKey);
        if (pubDateJson == null) {
            return null;
        }
        String year = DumpToActionsUtility.getStringValue(pubDateJson, "year");
        String month = DumpToActionsUtility.getStringValue(pubDateJson, "month");
        String day = DumpToActionsUtility.getStringValue(pubDateJson, "day");
        if (StringUtils.isBlank((CharSequence)year)) {
            return null;
        }
        String pubDate = "".concat(year);
        if (StringUtils.isNotBlank((CharSequence)month)) {
            pubDate = pubDate.concat("-" + month);
            pubDate = StringUtils.isNotBlank((CharSequence)day) ? pubDate.concat("-" + day) : pubDate + "-01";
        } else {
            pubDate = pubDate + "-01-01";
        }
        if (DumpToActionsUtility.isValidDate(pubDate)) {
            return pubDate;
        }
        return null;
    }

    protected static boolean isValid(JsonObject rootElement, Reporter context) {
        String type = DumpToActionsUtility.getStringValue(rootElement, "type");
        if (!typologiesMapping.containsKey(type)) {
            context.incrementCounter("filtered", "unknowntype_" + type, 1L);
            return false;
        }
        if (!OrcidToActions.isValidJsonArray(rootElement, "titles")) {
            context.incrementCounter("filtered", "invalid_title", 1L);
            return false;
        }
        return true;
    }

    private static boolean isValidJsonArray(JsonObject rootElement, String fieldName) {
        if (!rootElement.has(fieldName)) {
            return false;
        }
        JsonElement jsonElement = rootElement.get(fieldName);
        if (jsonElement.isJsonNull()) {
            return false;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            if (jsonArray.isJsonNull()) {
                return false;
            }
            if (jsonArray.get(0).isJsonNull()) {
                return false;
            }
        }
        return true;
    }

    static {
        try {
            InputStream is = OrcidToActions.class.getResourceAsStream("/eu/dnetlib/data/mapreduce/hbase/dataimport/mapping_typologies_orcid.json");
            String tt = IOUtils.toString((InputStream)is);
            typologiesMapping = (Map)new Gson().fromJson(tt, Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

