/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.openorgs;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.mapreduce.hbase.openorgs.OpenOrgsCommon;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class AbstractOpenOrgsMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    private ImmutableBytesWritable keyOut;
    private ImmutableBytesWritable valueOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
        this.valueOut = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            if (DedupUtils.isRoot(keyIn)) {
                context.getCounter("organization", "dedupwf_____ row skipped").increment(1L);
                return;
            }
            if (OpenOrgsCommon.isOpenOrgsMesh(keyIn)) {
                context.getCounter("organization", "openorgsmesh row skipped").increment(1L);
                return;
            }
            byte[] bytes = (byte[])value.getFamilyMap(Bytes.toBytes((String)"organization")).get(Bytes.toBytes((String)"body"));
            if (bytes == null) {
                context.getCounter("organization", "empty body").increment(1L);
                return;
            }
            Set roots = value.getFamilyMap(Bytes.toBytes((String)"organizationOrganization_dedup_isMergedIn")).keySet();
            if (roots.isEmpty()) {
                context.getCounter("organization", "missing mergedIn relationship").increment(1L);
            }
            if (roots.size() > 1) {
                context.getCounter("organization", "too many mergedIn relationship").increment(1L);
            }
            String root = roots.isEmpty() ? null : new String((byte[])Iterables.getOnlyElement(roots), Charset.forName("UTF-8"));
            String keyOutString = this.calculateKeyOut(OafProtos.Oaf.parseFrom((byte[])bytes), root, context);
            if (StringUtils.isNotBlank((CharSequence)keyOutString)) {
                this.emit(keyOutString, bytes, context);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String calculateKeyOut(OafProtos.Oaf var1, String var2, Mapper.Context var3);

    private void emit(String key, byte[] value, Mapper.Context context) {
        this.keyOut.set(key.getBytes());
        this.valueOut.set(value);
        try {
            context.write((Object)this.keyOut, (Object)this.valueOut);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

