package eu.dnetlib.data.mapreduce.hbase.broker;

import static eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory.asEvent;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;

import com.google.common.collect.Lists;

import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.HighlightFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.proto.FieldTypeProtos.StringField;
import eu.dnetlib.data.proto.OafProtos.Oaf;

/**
 * Created by claudio on 26/07/16.
 */
public class AbstractEventFactory { // Abstract of the publication

	public static List<EventWrapper> process(final Oaf current, final Oaf other, final float trust)
			throws IOException, InterruptedException, DocumentException {
		return new AbstractEventFactory().processAbstract(current, other, trust);
	}

	private List<EventWrapper> processAbstract(final Oaf current, final Oaf other, final float trust)
			throws IOException, InterruptedException, DocumentException {

		final List<EventWrapper> events = Lists.newArrayList();

		if (hasAbstract(other)) {
			// doProcessAbstract(context, current, other, Topic.MORE_ABSTRACT);

			if (!hasAbstract(current)) {
				events.add(doProcessAbstract(current, other, Topic.ENRICH_MISSING_ABSTRACT, trust));
			}
		}

		return events;
	}

	private EventWrapper doProcessAbstract(final Oaf current, final Oaf other, final Topic topic, final float trust)
			throws IOException, InterruptedException, DocumentException {
		final Oaf.Builder prototype = Oaf.newBuilder(current);
		final List<StringField> descriptionList = other.getEntity().getResult().getMetadata().getDescriptionList();
		prototype.getEntityBuilder().getResultBuilder().getMetadataBuilder().addAllDescription(descriptionList);

		final Oaf oaf = prototype.build();

		final OpenAireEventPayload payload =
				HighlightFactory.highlightEnrichAbstract(OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), other.getEntity(), trust), descriptionList);

		return EventWrapper.newInstance(
				asEvent(oaf.getEntity(), topic, payload, other.getEntity(), trust),
				payload.getHighlight().getAbstracts().stream().filter(StringUtils::isNotBlank).sorted().collect(Collectors.joining(", ")),
				topic.getValue());
	}

	private boolean hasAbstract(final Oaf oaf) {
		return oaf.getEntity().getResult().getMetadata().getDescriptionList()
				.stream()
				.anyMatch(s -> StringUtils.isNotBlank(s.getValue()));
	}

}
