/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.datasource;

import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.compositekeys.InstOrgKey;
import eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.datasource.ResultOrganizationIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult.PropagationProjectToResultReducer;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PropagationProductToOrganizationReducer
extends TableReducer<InstOrgKey, Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(PropagationProjectToResultReducer.class);
    private ImmutableBytesWritable keyOut;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
    }

    protected void reduce(InstOrgKey key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        ResultOrganizationIterator rh = null;
        try {
            rh = new ResultOrganizationIterator(values, key.getKeyType().get());
        }
        catch (NotValidResultSequenceException e) {
            context.getCounter("Propagation", e.getMessage()).increment(1L);
            return;
        }
        while (rh.hasNext()) {
            Object oafList = ((ResultIterator)rh).next();
            Iterator iterator = oafList.iterator();
            while (iterator.hasNext()) {
                OafProtos.Oaf oaf = (OafProtos.Oaf)iterator.next();
                String source = oaf.getRel().getSource();
                Put put = new Put(Bytes.toBytes((String)source)).add(Bytes.toBytes((String)(PropagationConstants.REL_TYPE_ORGANIZATION + oaf.getRel().getRelClass())), Bytes.toBytes((String)oaf.getRel().getTarget()), oaf.toByteArray());
                this.keyOut.set(Bytes.toBytes((String)source));
                context.write((Object)this.keyOut, (Object)put);
            }
            context.getCounter("Propagation", "Added result to organizationtoresult").increment((long)(oafList.size() / 2));
        }
    }
}

