package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.TypeProtos;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;

import java.util.Map;

/**
 * Created by claudio on 21/02/2017.
 */
public abstract class AbstractEnrichmentMapper extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {

	protected ImmutableBytesWritable outValue;

	protected ImmutableBytesWritable outKey;

	protected abstract String counterGroup();

	@Override
	protected void setup(final Context context) {
		outKey = new ImmutableBytesWritable();
		outValue = new ImmutableBytesWritable();
	}

	protected void emit(final Context context, final byte[] key, final byte[] value, final String entityType) {
		outKey.set(key);
		outValue.set(value);
		try {
			context.write(outKey, outValue);
			context.getCounter(counterGroup(), "entity type: " + entityType).increment(1);
		} catch (Exception e) {
			throw new IllegalArgumentException(e);
		}
	}

	protected byte[] getEmitKey(final Context context, final ImmutableBytesWritable key, final Map<byte[], byte[]> mergedIn) {
		if (MapUtils.isNotEmpty(mergedIn)) {
			context.getCounter(TypeProtos.Type.result.name(), DedupProtos.Dedup.RelName.isMergedIn.name()).increment(1);

			//TODO a duplicate should be merged into only one representative object, but we noticed some cases where
			// a duplicate is merged in two different representative objects
			return mergedIn.keySet().iterator().next();
		} else {
			return key.copyBytes();
		}
	}

}
