/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.experiment;

import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class PublicationAnalysisMapper
extends TableMapper<NullWritable, NullWritable> {
    public static final String RESULT = "result";
    private static final int MAX_DESCRIPTIONS = 50;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        if (new String(key.copyBytes()).contains("dedup_wf")) {
            context.getCounter(RESULT, "roots").increment(1L);
            return;
        }
        byte[] body = value.getValue(RESULT.getBytes(), DedupUtils.BODY_B);
        if (body == null) {
            context.getCounter(RESULT, "missing body").increment(1L);
            return;
        }
        OafDecoder decoder = OafDecoder.decode((byte[])body);
        ResultProtos.Result result = decoder.getEntity().getResult();
        if (result.getMetadata().getResulttype().getClassid().equals("dataset")) {
            context.getCounter(RESULT, "dataset").increment(1L);
            return;
        }
        context.getCounter(RESULT, "publication").increment(1L);
        if (result.getMetadata().getDescriptionCount() > 50) {
            context.getCounter(RESULT, "abstracts > 50").increment(1L);
        } else {
            context.getCounter(RESULT, "abstracts: " + result.getMetadata().getDescriptionCount()).increment(1L);
        }
        List descList = result.getMetadata().getDescriptionList();
        boolean empty = true;
        for (FieldTypeProtos.StringField desc : descList) {
            empty = empty && StringUtils.isBlank((String)desc.getValue());
        }
        context.getCounter(RESULT, "empty abstract: " + empty).increment(1L);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
    }
}

