/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.fixrelation;

import eu.dnetlib.data.mapreduce.hbase.dedup.fixrelation.Key;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupFixRelationMapper
extends TableMapper<Key, ImmutableBytesWritable> {
    public static final String COUNTER_GROUP = "Fix relations";
    private ImmutableBytesWritable ibw;
    private TypeProtos.Type expectedType;

    protected void setup(Mapper.Context context) {
        this.expectedType = TypeProtos.Type.valueOf((String)context.getConfiguration().get("type"));
        this.ibw = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        String rowKey = new String(key.copyBytes());
        OafRowKeyDecoder rowKeyDecoder = OafRowKeyDecoder.decode((String)rowKey);
        TypeProtos.Type type = rowKeyDecoder.getType();
        if (!type.equals((Object)this.expectedType) || !DedupUtils.isRoot(rowKey)) {
            return;
        }
        OafProtos.Oaf oaf = OafHbaseUtils.getBody(value, type);
        if (oaf == null) {
            context.getCounter(COUNTER_GROUP, String.format("%s - missing body", type.toString())).increment(1L);
            return;
        }
        OafHbaseUtils.rel(value).forEach(rel -> {
            String targetId = rel.getRel().getTarget();
            if (!DedupUtils.isRoot(targetId)) {
                if (rel.getRel().getRelClass().equals("merges")) {
                    this.emit(context, Key.mergesRel(targetId), rel.toByteArray());
                } else {
                    this.emit(context, Key.otherRel(targetId), rel.toByteArray());
                }
            }
        });
    }

    private void emit(Mapper.Context context, Key key, byte[] value) {
        this.ibw.set(value);
        switch (key.getKeyType().get()) {
            case 0: {
                context.getCounter(COUNTER_GROUP, String.format("%s - Merge Relationship", this.expectedType)).increment(1L);
                break;
            }
            case 1: {
                context.getCounter(COUNTER_GROUP, String.format("%s - Other Relationship", this.expectedType)).increment(1L);
            }
        }
        try {
            context.write((Object)key, (Object)this.ibw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

