package eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts;

import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.*;
import eu.dnetlib.data.proto.*;
import org.apache.hadoop.io.Text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ResultOrcidIterator extends ResultIterator {

    private Iterator<String> author_iterator;
    private List<FieldTypeProtos.Author> autoritative_authors ;
    private List<String> relatedResult ;


    public ResultOrcidIterator(final Iterable<Text> values, final String key) throws NotValidResultSequenceException {
        super(values,key);
    }

    @Override
    protected void checkSequence() throws NotValidResultSequenceException {
        if(!it.hasNext()){
            throw new NotValidResultSequenceException("Empty information for key");
        }

        try {
            autoritative_authors = new ArrayList<>();
            relatedResult = new ArrayList<>();
            analizeValueList();

        }catch(JsonFormat.ParseException e){
            throw new NotValidResultSequenceException("Problems recreating the author list from serialization");
        }

        List<FieldTypeProtos.Author> authors_with_orcid = autoritative_authors.stream()
                .map(a -> {
                    if (a.getPidList() == null || a.getPidList().isEmpty())
                        return null;
                    return a;
                })
                .filter(a -> a!= null)
                .filter(a -> containsOrcid(a.getPidList()))
                .collect(Collectors.toList());


        if(authors_with_orcid.size() == 0 || relatedResult.size() == 0){
            resultId = TERMINATOR;
            return;
        }


        author_iterator = relatedResult.iterator();
        autoritative_authors = authors_with_orcid;
        getNext();

    }

    private boolean containsOrcid(List<FieldTypeProtos.KeyValue> pidList){
        if(pidList == null)
            return false;
        return pidList
                .stream()
                .filter(kv -> kv.getKey().equals(PropagationConstants.AUTHOR_PID))
                .collect(Collectors.toList()).size() > 0;
    }

    private void getNext(){
        if (author_iterator.hasNext())
            resultId = author_iterator.next();
        else
            resultId = TERMINATOR;
    }

    @Override
    public List<OafProtos.Oaf> next() {
        //get the next merged author list
        try {
            //list of authors in the related result
            Emit e = Emit.fromJson(resultId);
            List<FieldTypeProtos.Author> author_list = getAuthorList(e);

            ResultProtos.Result.Metadata.Builder metadata = searchMatch(author_list);

            if (metadata != null){
                ArrayList<OafProtos.Oaf> ret = new ArrayList<OafProtos.Oaf>(Arrays.asList(getUpdate(metadata, e.getId())));
                getNext();
                return ret;
            }


        }catch(JsonFormat.ParseException e){

        }
        getNext();
        return null;
    }

    private ResultProtos.Result.Metadata.Builder searchMatch(List<FieldTypeProtos.Author> author_list){
        ResultProtos.Result.Metadata.Builder metadataBuilder = ResultProtos.Result.Metadata.newBuilder();
        boolean updated = false;
//        for (FieldTypeProtos.Author a: autoritative_authors){
//            searchAuthor(a,author_list);
//        }

        for (FieldTypeProtos.Author a: author_list){
            FieldTypeProtos.Author.Builder author = searchAuthor(a, autoritative_authors);
            if(author != null){
                updated = true;
                metadataBuilder.addAuthor(author);
            }else{
                metadataBuilder.addAuthor(FieldTypeProtos.Author.newBuilder(a));
            }
        }
        if(updated)
            return metadataBuilder;
        return null;
    }


    private boolean equals(FieldTypeProtos.Author a1, FieldTypeProtos.Author a2){
        if(a1.hasSurname()){
            if(a2.hasSurname()){
                if(!a1.getSurname().trim().equalsIgnoreCase(a2.getSurname().trim())){
                    return false;
                }
                //have the same surname. Check the name
                if(a1.hasName()){
                    if (a2.hasName()){
                        if (a1.getName().trim().equalsIgnoreCase(a2.getName().trim())){
                            return true; //same name and same surname in a related research result
                        }
                        //they could be differently written (i.e. only the initials of the name in one of the two
                        return (a1.getName().trim().substring(0,0).equalsIgnoreCase(a2.getName().trim().substring(0,0)));
                    }
                }
            }
        }
//        if(a1.hasFullname()){
//            if (a2.hasFullname()){
//                if (a1.getFullname().trim().equalsIgnoreCase(a2.getFullname().trim())){
//                    return true;
//                }
//                //split string containing name and surname
//                String[] ns_a1 = a1.getFullname().trim().split(" ");
//                String[] ns_a2 = a2.getFullname().trim().split(" ");
//
//
//                if (ns_a1[0].endsWith(".") || ns_a1[0].endsWith(",")){
//                    ns_a1[0] = ns_a1[0].substring(0,ns_a1[0].length()-1);
//                }
//                if (ns_a1[1].endsWith(".") || ns_a1[1].endsWith(",")){
//                    ns_a1[1] = ns_a1[1].substring(0,ns_a1[1].length()-1);
//                }
//
//                if (ns_a2[0].endsWith(".") || ns_a2[0].endsWith(",")){
//                    ns_a2[0] = ns_a2[0].substring(0,ns_a2[0].length()-1);
//                }
//                if (ns_a2[1].endsWith(".") || ns_a2[1].endsWith(",")){
//                    ns_a2[1] = ns_a2[1].substring(0,ns_a2[1].length()-1);
//                }
//
//                if(ns_a1[0].compareTo(ns_a1[1]) < 0){
//                    String tmp = ns_a1[0];
//                    ns_a1[0] = ns_a1[1];
//                    ns_a1[1] = tmp;
//                }
//
//                if(ns_a2[0].compareTo(ns_a2[1]) < 0){
//                    String tmp = ns_a2[0];
//                    ns_a2[0] = ns_a2[1];
//                    ns_a2[1] = tmp;
//
//                }
//
//                if(ns_a1[0].equalsIgnoreCase(ns_a2[0])){
//                    if(ns_a1[1].equalsIgnoreCase(ns_a2[1])){//same name and surname
//                        return true;
//                    }
//                    if(ns_a1[1].length() == 1 || ns_a2[1].length() == 1){
//                        return ns_a1[1].charAt(0) == ns_a2[1].charAt(0);//same surname and initial of the name
//                    }
//                    return false;
//
//                }else{
//                    if(ns_a1[1].equalsIgnoreCase(ns_a2[1])){
//                        if(ns_a1[0].length() == 1 || ns_a2[0].length()==1)
//                            return ns_a1[0].charAt(0) == ns_a2[0].charAt(0);
//                        else
//                            return false;
//                    }
//                }
//
//
//
//        }
//        return false;
//    }
        return false;

    }

    private FieldTypeProtos.Author.Builder searchAuthor(FieldTypeProtos.Author a, List<FieldTypeProtos.Author> author_list){
        if(containsOrcid(a.getPidList()))
            return null;
        for(FieldTypeProtos.Author autoritative_author : author_list) {
                if (equals(autoritative_author, a)) {
                    if(!containsOrcid(a.getPidList()))
                        return update(a, autoritative_author);
                }
        }
        return  null;

    }

    private void analizeValueList() throws JsonFormat.ParseException {
        while(it.hasNext()){
            Value v = Value.fromJson(it.next().toString());

            if(v.getType().equals(PropagationConstants.Type.fromresult)){
                autoritative_authors.addAll(getAuthorList(Emit.fromJson(v.getValue ())));
            }
            if(v.getType().equals(PropagationConstants.Type.fromsemrel)){
                relatedResult.add(v.getValue());
            }
        }

    }
    private FieldTypeProtos.Author.Builder update(FieldTypeProtos.Author related_author, FieldTypeProtos.Author autoritative_autor ){

        FieldTypeProtos.Author.Builder res = FieldTypeProtos.Author.newBuilder(related_author);
        List<FieldTypeProtos.KeyValue> apid_list = autoritative_autor.getPidList();
        FieldTypeProtos.KeyValue akv = apid_list.stream().filter(kv -> kv.getKey().equals(PropagationConstants.AUTHOR_PID)).collect(Collectors.toList()).get(0);
        FieldTypeProtos.KeyValue.Builder kvb = FieldTypeProtos.KeyValue.newBuilder();
        kvb.setKey(akv.getKey()).setValue(akv.getValue());
        kvb.setDataInfo(Utils.getDataInfo(
                PropagationConstants.ORCID_RESULT_TRUST,
                PropagationConstants.CLASS_ORCID_ID,
                PropagationConstants.SCHEMA_ID,
                PropagationConstants.SCHEMA_NAME,
                PropagationConstants.DATA_INFO_TYPE,
                PropagationConstants.CLASS_ORCID_NAME)
        );
        return res.addPid(kvb);


    }

    private List<FieldTypeProtos.Author> getAuthorList(Emit e) throws JsonFormat.ParseException {

        List<FieldTypeProtos.Author> authors = new ArrayList<>();
        for (String author : e.getAuthor_list()) {
            FieldTypeProtos.Author.Builder author_builder = FieldTypeProtos.Author.newBuilder();
            JsonFormat.merge(author, author_builder);
            authors.add(author_builder.build());
        }

        return authors;

    }


    public static OafProtos.Oaf getUpdate(ResultProtos.Result.Metadata.Builder metadata, String resultId) {
        final ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder().setMetadata(metadata);
        final OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder()
                .setType(TypeProtos.Type.result)
                .setId(resultId)
                .setResult(result);

        return OafProtos.Oaf.newBuilder()
                .setKind(KindProtos.Kind.entity)
                .setEntity(entity)
                .build();
    }
}
