/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware;

import com.google.common.collect.Lists;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.Identifier;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.IdentifierList;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.ReturnedValues;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.SoftwareResource;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.Value;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PubSfwLinkReducer
extends Reducer<ImmutableBytesWritable, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(PubSfwLinkReducer.class);
    private Text keyOut;
    private Text outValue;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text("");
        this.outValue = new Text();
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        ReturnedValues ret = ReturnedValues.newInstance();
        Iterator<Text> it = values.iterator();
        while (it.hasNext()) {
            Value value = Value.fromJson(it.next().toString());
            if (value == null) continue;
            switch (value.getType()) {
                case publication: {
                    ret.setPublicationPIDs(IdentifierList.fromJson(value.getValue()));
                    break;
                }
                case software: {
                    ret.getLinkedSW().add(SoftwareResource.fromJson(value.getValue()));
                }
            }
        }
        if (ret.getLinkedSW().size() > 0 && ret.getPublicationPIDs() != null) {
            ret.setOpenAireId(Bytes.toString((byte[])key.copyBytes()));
            this.outValue.set(ret.toJson());
            context.write((Object)this.keyOut, (Object)this.outValue);
            context.getCounter("Find Link Pub Software", "write new association").increment(1L);
        }
    }

    private List<String> getURLs(List<SoftwareResource> list) {
        HashSet a = list.stream().map(s -> s.getUrls()).flatMap(Collection::stream).collect(Collectors.toCollection(HashSet::new));
        return Lists.newArrayList((Iterable)a);
    }

    private List<Identifier> getPids(List<SoftwareResource> list) {
        return Lists.newArrayList(list.stream().map(s -> s.getSoftwarePIDs()).flatMap(Collection::stream).collect(Collectors.toMap(Identifier::getPid, Function.identity(), (id1, id2) -> id1)).values());
    }

    private String getId(List<SoftwareResource> list) {
        return list.get(0).getOpenAireId();
    }
}

