/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.semrel;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.Emit;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.ResultOrganizationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.io.Text;

public class ResultOrganizationIterator
extends ResultIterator {
    private Set<String> alreadyAffiliated;
    private Set<String> toBeAffiliated;
    private String organizationToPropagate;
    private Iterator<String> roi;

    public ResultOrganizationIterator(Iterable<Text> values, int key) throws NotValidResultSequenceException {
        super(values, key);
        this.init();
    }

    private void init() {
        this.roi = this.toBeAffiliated.iterator();
        this.getNext();
    }

    @Override
    protected void checkSequence() throws NotValidResultSequenceException {
        if (!this.it.hasNext()) {
            throw new NotValidResultSequenceException("Empty information for key");
        }
        Value first = Value.fromJson(((Text)this.it.next()).toString());
        this.trust = first.getTrust();
        if (this.key != TypeProtos.Type.datasource.getNumber()) {
            throw new NotValidResultSequenceException("First Element in reducer has not datasource as type, means no association with datasource was found for the organization ");
        }
        if (first.getValue().equals("1")) {
            if (!this.it.hasNext()) {
                throw new NotValidResultSequenceException("No information apart of type of datasource");
            }
            this.organizationToPropagate = Value.fromJson(((Text)this.it.next()).toString()).getValue();
            if (!this.organizationToPropagate.startsWith("20|")) {
                throw new NotValidResultSequenceException("Second element in reducer is not the organization");
            }
            this.alreadyAffiliated = new HashSet<String>();
            this.toBeAffiliated = new HashSet<String>();
            while (this.it.hasNext()) {
                Value v = Value.fromJson(((Text)this.it.next()).toString());
                if (!v.getType().equals((Object)PropagationConstants.Type.fromresult)) {
                    throw new NotValidResultSequenceException("result in reducer mixed up with other types ");
                }
                Emit e = (Emit)new Gson().fromJson(v.getValue(), Emit.class);
                this.alreadyAffiliated.add(e.getId());
                this.toBeAffiliated.addAll(e.getResult_list());
            }
        } else {
            throw new NotValidResultSequenceException("Not allowed dsType institutional datasource");
        }
        this.toBeAffiliated.removeAll(this.alreadyAffiliated);
    }

    private void getNext() {
        this.resultId = this.roi.hasNext() ? this.roi.next() : "FINITO";
    }

    @Override
    public List<OafProtos.Oaf> next() {
        ArrayList<OafProtos.Oaf> ret = new ArrayList<OafProtos.Oaf>();
        ret.add(this.getOafRel(this.resultId, this.organizationToPropagate, "hasAuthorInstitution"));
        ret.add(this.getOafRel(this.organizationToPropagate, this.resultId, "isAuthorInstitutionOf"));
        this.getNext();
        return ret;
    }

    private OafProtos.Oaf getOafRel(String source, String target, String semantics) {
        ResultOrganizationProtos.ResultOrganization.Builder rob = ResultOrganizationProtos.ResultOrganization.newBuilder().setAffiliation(ResultOrganizationProtos.ResultOrganization.Affiliation.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(Utils.getQualifier(semantics, "dnet:result_organization_relation", semantics, "dnet:result_organization_relation"))));
        OafProtos.OafRel.Builder relation = OafProtos.OafRel.newBuilder().setChild(false).setSubRelType(PropagationConstants.SUBREL_TYPE_ORGANIZATION).setRelType(PropagationConstants.REL_TYPE_ORGANIZATION).setRelClass(semantics).setTarget(target).setSource(source).setResultOrganization(rob);
        return OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation).setRel(relation).setDataInfo(Utils.getDataInfo(this.trust, "propagation:result:organizationtoresult", "dnet:provenanceActions", "dnet:provenanceActions", "propagation", "Propagation of result linked to organization to result through result linked by isSupplementTo or isSupplementedBy")).build();
    }
}

