/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult;

import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult.ResultProjectIterator;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PropagationProjectToResultReducer
extends TableReducer<ImmutableBytesWritable, Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(PropagationProjectToResultReducer.class);
    private ImmutableBytesWritable keyOut;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        ResultProjectIterator rh = null;
        try {
            rh = new ResultProjectIterator(values, Bytes.toString((byte[])key.copyBytes()));
        }
        catch (NotValidResultSequenceException e) {
            context.getCounter("Propagation", e.getMessage()).increment(1L);
            return;
        }
        while (rh.hasNext()) {
            Iterator iterator = ((ResultIterator)rh).next().iterator();
            while (iterator.hasNext()) {
                OafProtos.Oaf oaf = (OafProtos.Oaf)iterator.next();
                String source = oaf.getRel().getSource();
                Put put = new Put(Bytes.toBytes((String)source)).add(Bytes.toBytes((String)(PropagationConstants.RELATION + oaf.getRel().getRelClass())), Bytes.toBytes((String)oaf.getRel().getTarget()), oaf.toByteArray());
                this.keyOut.set(Bytes.toBytes((String)source));
                context.write((Object)this.keyOut, (Object)put);
            }
            context.getCounter("Propagation", "Added relation to project").increment(1L);
        }
    }
}

