package eu.dnetlib.data.mapreduce.hbase.dataimport;

import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.OafProtos;
import org.apache.hadoop.hbase.util.Bytes;

import static eu.dnetlib.data.proto.OafProtos.Oaf;

public class GridAcToActions {

    private final static String columnFamily = "organizationOrganization_dedupSimilarity_isSimilarTo";

    public static AtomicAction generateActionsFromDump(final Oaf oaf, ActionFactory factory, final String setName, final Agent agent) {

        switch (oaf.getKind()) {
            case entity:
                return factory.createAtomicAction(setName, agent, oaf.getEntity().getId(), "organization", "body", oaf.toByteArray());
            case relation:
                final OafProtos.OafRel rel = oaf.getRel();
                return factory.createAtomicAction(setName, agent, rel.getSource(), columnFamily, rel.getTarget(), Bytes.toBytes(""));
        }

        // should not happen
        return null;
    }

}
