/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import eu.dnetlib.data.mapreduce.hbase.broker.SoftwareEventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.enrich.AbstractEnrichmentReducer;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class SoftwareEnrichmentReducer
extends AbstractEnrichmentReducer {
    @Override
    protected String counterGroup() {
        return "Broker Enrichment Software";
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        HashMap software = Maps.newHashMap();
        ArrayList pubs = Lists.newArrayList();
        Streams.stream(values).limit(1000L).map(AbstractEnrichmentReducer::toOaf).forEach(oaf -> {
            switch (oaf.getEntity().getResult().getMetadata().getResulttype().getClassid()) {
                case "publication": {
                    pubs.add(oaf);
                    break;
                }
                case "software": {
                    software.put(oaf.getEntity().getId(), oaf);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid type: " + oaf.getEntity().getType());
                }
            }
        });
        if (software.isEmpty() || pubs.isEmpty()) {
            context.getCounter(this.counterGroup(), "Events Skipped - Nothing to do").increment(1L);
            return;
        }
        try {
            this.generateEvents(pubs, software, context);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateEvents(List<OafProtos.Oaf> pubs, Map<String, OafProtos.Oaf> software, Reducer.Context context) throws IOException, InterruptedException, DocumentException {
        List valid = pubs.stream().map(p -> this.addSoftware((OafProtos.Oaf)p, software)).filter(r -> !r.getEntity().getCachedOafRelList().isEmpty()).collect(Collectors.toList());
        if (valid.isEmpty()) {
            context.getCounter(this.counterGroup(), "Events Skipped - Missing software").increment(1L);
            return;
        }
        for (OafProtos.Oaf current : valid) {
            String currentId = current.getEntity().getId();
            String currentDsId = StringUtils.substringAfter((String)OafHbaseUtils.getKey(current.getEntity().getCollectedfromList()), (String)"|");
            String currentDsType = (String)this.dsTypeMap.get(currentDsId);
            if (StringUtils.isBlank((String)currentDsType) && !this.dsWhitelist.contains(currentDsId)) {
                context.getCounter(this.counterGroup(), "Events Skipped - Datasource type excluded").increment(1L);
                continue;
            }
            if (this.dsBlacklist.contains(currentDsId)) {
                context.getCounter(this.counterGroup(), "Events Skipped - Datasource blacklisted").increment(1L);
                continue;
            }
            ArrayList events = Lists.newArrayList();
            if (valid.size() == 1) {
                events.addAll(SoftwareEventFactory.process(context, (OafProtos.Oaf)valid.get(0), this.baseUrlMap));
            } else {
                for (OafProtos.Oaf other : valid) {
                    String otherId = other.getEntity().getId();
                    if (currentId.equals(otherId)) continue;
                    double similarity = this.similarity(current, other);
                    if (similarity >= this.dedupConf.getWf().getThreshold()) {
                        float trust = this.scale(similarity);
                        events.addAll(SoftwareEventFactory.process(context, current, other, Float.valueOf(trust), this.baseUrlMap));
                        continue;
                    }
                    context.getCounter(this.counterGroup(), "d < " + this.dedupConf.getWf().getThreshold()).increment(1L);
                }
            }
            this.emit(events, context);
        }
    }

    private OafProtos.Oaf addSoftware(OafProtos.Oaf current, Map<String, OafProtos.Oaf> softwareMap) {
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)current);
        ArrayList cachedRels = Lists.newArrayList();
        for (OafProtos.Oaf.Builder cachedOafRel : oafBuilder.getEntityBuilder().getCachedOafRelBuilderList()) {
            String softwareId = cachedOafRel.getRel().getTarget();
            if (!softwareMap.containsKey(softwareId)) continue;
            OafProtos.Oaf software = softwareMap.get(softwareId);
            cachedOafRel.getRelBuilder().setCachedOafTarget(software);
            cachedRels.add(cachedOafRel.build());
        }
        oafBuilder.getEntityBuilder().clearCachedOafRel().addAllCachedOafRel((Iterable)cachedRels);
        return oafBuilder.build();
    }
}

