/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.bulktag.ProtoMap;
import eu.dnetlib.data.mapreduce.hbase.dataexport.RecordFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Year;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class ExportFilteredResultMapper
extends Mapper<Text, Text, Text, Text> {
    private static final String RESULT_TYPE_XPATH = "/*[local-name() ='record']/*[local-name() ='result']/*[local-name() ='metadata']/*[local-name() ='entity']/*[local-name() ='result']/*[local-name() ='resulttype']/@classid";
    private Text keyOut;
    private Text valueOut;
    private RecordFilter defaultFilter;
    private RecordFilter userFilter;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.keyOut = new Text("");
        this.valueOut = new Text();
        this.defaultFilter = new RecordFilter((Map)new Gson().fromJson(context.getConfiguration().get("filter.defaultcriteria", "{}"), ProtoMap.class), context.getConfiguration().get("filter.yearxpath"), 0, Year.now().getValue());
        this.userFilter = new RecordFilter((Map)new Gson().fromJson(context.getConfiguration().get("filter.criteria", "{}"), ProtoMap.class), context.getConfiguration().get("filter.yearxpath"), context.getConfiguration().getInt("filter.fromyear", 0), context.getConfiguration().getInt("filter.toyear", 0));
    }

    protected void map(Text keyIn, Text value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            String record = value.toString();
            Document doc = new SAXReader().read((Reader)new StringReader(record));
            if (this.defaultFilter.matches(doc, true)) {
                if (this.userFilter.matches(doc, false)) {
                    this.keyOut.set(keyIn.toString());
                    this.valueOut.set(value.toString());
                    context.write((Object)this.keyOut, (Object)this.valueOut);
                    context.getCounter("filter", "matched criteria " + doc.valueOf(RESULT_TYPE_XPATH)).increment(1L);
                } else {
                    context.getCounter("filter", "filtered by criteria").increment(1L);
                }
            } else {
                context.getCounter("filter", "filtered by default criteria").increment(1L);
            }
        }
        catch (Throwable e) {
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }
}

