/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.model.MapDocumentSerializer;
import eu.dnetlib.pace.util.BlockProcessor;
import eu.dnetlib.pace.util.Reporter;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class DedupReducer
extends TableReducer<Text, ImmutableBytesWritable, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(DedupReducer.class);
    private DedupConfig dedupConf;
    private ImmutableBytesWritable ibw;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfig.load((String)context.getConfiguration().get("dedup.conf"));
        this.ibw = new ImmutableBytesWritable();
        log.info((Object)("dedup reduce phase \npace conf: " + this.dedupConf.toString()));
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, final Reducer.Context context) {
        Iterable docs = Iterables.transform(values, (Function)new Function<ImmutableBytesWritable, MapDocument>(){

            @Nullable
            public MapDocument apply(@Nullable ImmutableBytesWritable b) {
                return MapDocumentSerializer.decode((byte[])b.copyBytes());
            }
        });
        new BlockProcessor(this.dedupConf).process(key.toString(), docs, new Reporter(){

            public void incrementCounter(String counterGroup, String counterName, long delta) {
                context.getCounter(counterGroup, counterName).increment(delta);
            }

            public void emit(String type, String from, String to) {
                this.emitRel(context, type, from, to);
                this.emitRel(context, type, to, from);
            }

            private void emitRel(Reducer.Context context2, String type, String from, String to) {
                Put put = new Put(Bytes.toBytes((String)from)).add(DedupUtils.getSimilarityCFBytes(type), Bytes.toBytes((String)to), Bytes.toBytes((String)""));
                put.setDurability(Durability.SKIP_WAL);
                DedupReducer.this.ibw.set(Bytes.toBytes((String)from));
                try {
                    context2.write((Object)DedupReducer.this.ibw, (Object)put);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

