/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.communitytoresult;

import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class CommunityToResultReducer
extends TableReducer<Text, Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(CommunityToResultReducer.class);
    private ImmutableBytesWritable keyOut;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
    }

    protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        Iterator<Text> it = values.iterator();
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        HashSet<String> added_context = new HashSet<String>();
        while (it.hasNext()) {
            Value v = Value.fromJson(it.next().toString());
            if (added_context.contains(v.getValue())) continue;
            metadata.addContext(Utils.getContext(v.getValue(), v.getTrust(), "propagation:community:productsthroughsemrel", "propagation", " Propagation of result belonging to community through semantic relation"));
            added_context.add(v.getValue());
        }
        String rowKey = key.toString();
        Put put = new Put(Bytes.toBytes((String)rowKey)).add(Bytes.toBytes((String)"result"), Bytes.toBytes((String)("update_" + System.nanoTime())), Utils.getUpdate(metadata, rowKey).toByteArray());
        this.keyOut.set(Bytes.toBytes((String)rowKey));
        context.write((Object)this.keyOut, (Object)put);
        context.getCounter("Propagation", "added community to result").increment(1L);
    }
}

