package eu.dnetlib.data.mapreduce.hbase.propagation;

import eu.dnetlib.data.proto.OafProtos;
import org.apache.hadoop.io.Text;

import java.util.Iterator;
import java.util.List;


public abstract class ResultIterator implements Iterator<List<OafProtos.Oaf>>{

    protected Iterator<Text> it;
    protected int key;
    protected String keyb;
    protected String resultId;
    protected boolean propagate = true;
    protected final static String TERMINATOR = "FINITO";
    protected String trust = null;

    public ResultIterator(final Iterable<Text> values, int key) throws NotValidResultSequenceException {
        it = values.iterator();
        this.key = key;
        checkSequence();
    }

    public ResultIterator(final Iterable<Text> values, final String key) throws NotValidResultSequenceException {
        it = values.iterator();
        this.keyb = key;
        checkSequence();
    }

    protected abstract void checkSequence() throws NotValidResultSequenceException ;
    public abstract List<OafProtos.Oaf> next() ;

    public boolean hasNext(){
        return (!resultId.equals(TERMINATOR) && propagate);
    }

    public boolean getPropagate(){
        return propagate;
    }

    public String getResultId(){
        return resultId;
    }

}

