package eu.dnetlib.data.mapreduce.hbase.propagation;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.Type;

public class Value {

    public static final String DEFAULT_TRUST = "0";
    private Type type;
    private String value;
    private String trust;

    public Value(String value) {
        this(value, DEFAULT_TRUST);
    }

    public Value(String value, Type type) {
        this.value = value;
        this.type=type;
    }

    public Value(String value, String trust, Type type) {

        this.value=value;
        this.trust=trust;
        this.type=type;
    }

    public static Value newInstance(String value, String trust) {
        return new Value(value, trust);
    }

    public static Value newInstance(String value) {
        return new Value(value);
    }

    public static Value newInstance(String value,Type type) {
        return new Value(value,type);
    }

    public static Value newInstance(String value, String trust, Type type){
        return new Value(value,trust,type);
    }

    public static Value fromJson(final String json) {
        return new Gson().fromJson(json, Value.class);
    }

    public Value(String value, String trust) {
        this.value = value;
        this.trust = trust;
    }

    public String getValue() {
        return value;
    }

    public Value setValue(String value) {
        this.value = value;
        return this;
    }

    public String getTrust() {
        return trust;
    }

    public Value setTrust(String trust) {
        this.trust = trust;
        return this;
    }

    public String toJson() {
        return new Gson().toJson(this);
    }


    public Type getType() {
        return type;
    }

    public Value setType(Type type) {
        this.type = type;
        return this;
    }
}
