package eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories;

import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.compositekeys.InstOrgKey;
import eu.dnetlib.data.proto.OafProtos;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

import java.io.IOException;
import java.util.List;

import static eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.COUNTER_PROPAGATION;

public class PropagationCountryFromDsOrgResultFileReducer extends Reducer<InstOrgKey, Text, Text,Text> {

    private static final Log log = LogFactory.getLog(PropagationCountryFromDsOrgResultFileReducer.class); // NOPMD by marko on 11/24/08 5:02 PM

    private Text keyOut;

    private Text outValue;

    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {
        super.setup(context);
        keyOut = new Text("");
        outValue = new Text();

    }

    private void emit(final Context context, final String key, final String data) {

        outValue.set(data.getBytes());
        try {
            keyOut.set(key);
            context.write(keyOut, outValue);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void reduce(InstOrgKey key, Iterable<Text> values, Context context)  {

        ResultIterator rh = null;
        try {
            rh = new ResultCountryIterator(values,key.getKeyType().get());
        } catch (NotValidResultSequenceException e) {
            context.getCounter(COUNTER_PROPAGATION,e.getMessage()).increment(1);
            return;
        }
        context.getCounter(COUNTER_PROPAGATION,"institutional datasource").increment(1);

        while(rh.hasNext()){
            OafProtos.Oaf oafUpdate = rh.next().get(0);
            emit(context, oafUpdate.getEntity().getId(), JsonFormat.printToString(oafUpdate));
            context.getCounter(COUNTER_PROPAGATION, " added country to product ").increment(1);
        }

        if (!rh.getPropagate()){
            context.getCounter(COUNTER_PROPAGATION, "resultId expected in ordering was not found" ).increment(1);
        }


    }




}
