package eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories;

import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import org.apache.hadoop.io.Text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.*;
import static eu.dnetlib.data.mapreduce.hbase.propagation.Utils.getCountry;

public class ResultCountryIterator  extends ResultIterator {
    private String country;


    public ResultCountryIterator(final Iterable<Text> values, int key) throws NotValidResultSequenceException {
        super(values,key);
    }

    @Override
    protected void checkSequence() throws NotValidResultSequenceException {
        if (!it.hasNext()) {
            throw new NotValidResultSequenceException("Empty information for key");

        }
        final Value first = Value.fromJson(it.next().toString());
        trust = first.getTrust();
        if (!(first.getValue().equals(ZERO) || first.getValue().equals(ONE))) {
            if (key != TypeProtos.Type.datasource.getNumber()) {
                throw new NotValidResultSequenceException("First Element in reducer is not type of datasource,  but the organizationtoresult exists");
            } else {
                while (it.hasNext()) {

                    resultId = Value.fromJson(it.next().toString()).getValue();
                    if (!resultId.startsWith("50|")) {
                        throw new NotValidResultSequenceException("ERROR ORDERING CHECK");
                    }
                }
                throw new NotValidResultSequenceException("WARNING: unexpected first element");
            }
        }

        //ensure we are dealing with an institutional repository
        if (first.getValue().equals(ONE)) {
            //context.getCounter(COUNTER_PROPAGATION, "institutional datasource").increment(1);
            if (!it.hasNext()) {
                throw new NotValidResultSequenceException("No information apart of type of datasource");
            }


            country = Value.fromJson(it.next().toString()).getValue(); // need to update the information for the country to each element in the iterator
            if (country.trim().length() != 2) {
                try {
                    Integer.parseInt(country.trim());
                } catch (Exception e) {

                }
                throw new NotValidResultSequenceException("Second element in reducer is not country");
            }
            boolean iterate = true;
            resultId = TERMINATOR;
            while(it.hasNext() && iterate){
                resultId = Value.fromJson(it.next().toString()).getValue();
                if (!resultId.startsWith(("50|"))) {
                    if (!resultId.equalsIgnoreCase(country)) {
                        propagate = false;
                        iterate = false;

                    }
                }else{
                    propagate = true;
                    iterate = false;
                }

            }
            if (!resultId.equals(TERMINATOR)){
                try {
                    OafRowKeyDecoder.decode(resultId);
                }catch(IllegalArgumentException e){
                    throw new NotValidResultSequenceException("No result in sequence");
                }
            }
        }else
            throw new NotValidResultSequenceException("Not allowed dsType institutional datasource");
    }

    @Override
    public List<OafProtos.Oaf> next() {
        final ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder().addCountry(
                getCountry(country,trust,DNET_COUNTRY_SCHEMA,CLASS_COUNTRY_ID,SCHEMA_ID,SCHEMA_NAME,DATA_INFO_TYPE,CLASS_NAME_COUNTRY));
        final ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder().setMetadata(metadata);
        final OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder()
                .setType(TypeProtos.Type.result)
                .setId(resultId)
                .setResult(result);
        if(it.hasNext())
            resultId=Value.fromJson(it.next().toString()).getValue();
        else
            resultId = TERMINATOR;

        return new ArrayList<OafProtos.Oaf>(Arrays.asList(OafProtos.Oaf.newBuilder()
                .setKind(KindProtos.Kind.entity)
                .setEntity(entity)
                .build()));
    }



}
