/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.broker.objects.Project;
import eu.dnetlib.broker.objects.Software;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.ProtoMapping;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class HighlightFactory
extends ProtoMapping {
    public static OpenAireEventPayload highlightEnrichOa(OpenAireEventPayload p, Collection<ResultProtos.Result.Instance> instances) {
        p.getHighlight().setInstances(HighlightFactory.mapInstances(instances));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichPid(OpenAireEventPayload p, List<FieldTypeProtos.StructuredProperty> pids) {
        p.getHighlight().setPids(HighlightFactory.mapPids(pids));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichPublicationDate(OpenAireEventPayload p, FieldTypeProtos.StringField date) {
        p.getHighlight().setPublicationdate(OafHbaseUtils.getValue(date));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichAbstract(OpenAireEventPayload p, List<FieldTypeProtos.StringField> descriptionList) {
        p.getHighlight().setAbstracts(OafHbaseUtils.listValues(descriptionList));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichOrcidAuthor(OpenAireEventPayload p, FieldTypeProtos.Author author) {
        FieldTypeProtos.Author.Builder authorBuilder = FieldTypeProtos.Author.newBuilder((FieldTypeProtos.Author)author);
        List orcid = authorBuilder.getPidBuilderList().stream().filter(pid -> "ORCID".equals(pid.getKey())).map(pid -> pid.build()).collect(Collectors.toList());
        authorBuilder.clearPid().addAllPid(orcid);
        p.getHighlight().getCreators().add(OafHbaseUtils.mapValue(authorBuilder.build()));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichSubject(OpenAireEventPayload p, List<FieldTypeProtos.StructuredProperty> subjects) {
        p.getHighlight().setSubjects(OafHbaseUtils.listValues(subjects));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichProject(OpenAireEventPayload p, OafProtos.OafEntity project, String provenance) {
        p.getHighlight().setProjects((List)Lists.newArrayList((Object[])new Project[]{HighlightFactory.mapRelatedProject(project.getProject())}));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichSoftware(OpenAireEventPayload p, OafProtos.OafEntity software, String provenance) {
        p.getHighlight().setSoftwares((List)Lists.newArrayList((Object[])new Software[]{HighlightFactory.mapRelatedSoftware(software.getResult())}));
        return p;
    }

    public static OpenAireEventPayload highlightEnrichDataset(OpenAireEventPayload p) {
        return p;
    }

    public static OpenAireEventPayload highlightEnrichAuthorPid(OpenAireEventPayload p) {
        return p;
    }
}

