/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.data.mapreduce.hbase.dataexport.ProtoConverter;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;

public class ExportInformationSpaceMapper2DHP
extends TableMapper<Text, Text> {
    private Text keyOut;
    private Text valueOut;
    private MultipleOutputs multipleOutputs;
    private ObjectMapper objectMapper;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text("");
        this.valueOut = new Text();
        this.multipleOutputs = new MultipleOutputs((TaskInputOutputContext)context);
        this.objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        this.multipleOutputs.close();
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            OafRowKeyDecoder rkd = OafRowKeyDecoder.decode((byte[])keyIn.get());
            OafProtos.Oaf oaf = UpdateMerger.mergeBodyUpdates(context, value.getFamilyMap(Bytes.toBytes((String)rkd.getType().toString())));
            if (oaf == null) {
                return;
            }
            this.emit(context, oaf);
            Stream.of(value.raw()).filter(kv -> {
                boolean skip;
                String q = Bytes.toString((byte[])kv.getQualifier());
                boolean bl = skip = q.startsWith("update") || q.equals("body");
                if (skip) {
                    context.getCounter("export", String.format("skipped %s", StringUtils.substring((String)q, (int)0, (int)6))).increment(1L);
                }
                return !skip;
            }).filter(kv -> !"".equals(Bytes.toString((byte[])kv.getValue()))).map(kv -> kv.getValue()).forEach(v -> {
                try {
                    this.emit(context, OafProtos.Oaf.parseFrom((byte[])v));
                }
                catch (IOException | InterruptedException e) {
                    context.getCounter("export", "error: " + e.getClass().getName()).increment(1L);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Throwable e) {
            context.getCounter("export", "error: " + e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private void emit(Mapper.Context context, OafProtos.Oaf oaf) throws IOException, InterruptedException {
        Oaf result = null;
        try {
            result = ProtoConverter.convert(oaf);
        }
        catch (Throwable e) {
            context.getCounter("export", "error:" + e.getClass().getName()).increment(1L);
        }
        if (result != null) {
            this.valueOut.set(this.objectMapper.writeValueAsString((Object)result));
            String type = result.getClass().getSimpleName();
            String namedOutput = type.toLowerCase();
            this.multipleOutputs.write(namedOutput, (Object)this.keyOut, (Object)this.valueOut, namedOutput + "/" + namedOutput);
            boolean deleted = result.getDataInfo().getDeletedbyinference();
            if (result instanceof Relation) {
                Relation r = (Relation)result;
                String reltype = r.getRelType() + "_" + r.getSubRelType() + "_" + r.getRelClass();
                context.getCounter("export", String.format("%s deleted:%s", reltype, deleted)).increment(1L);
            } else if (result instanceof OafEntity) {
                context.getCounter("export", String.format("%s deleted:%s", type, deleted)).increment(1L);
            }
        }
    }
}

