/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.compositekeys.InstOrgKey;
import eu.dnetlib.data.mapreduce.hbase.propagation.country.institutionalrepositories.ResultCountryIterator;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PropagationCountryFromDsOrgResultFileReducer
extends Reducer<InstOrgKey, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(PropagationCountryFromDsOrgResultFileReducer.class);
    private Text keyOut;
    private Text outValue;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text("");
        this.outValue = new Text();
    }

    private void emit(Reducer.Context context, String key, String data) {
        this.outValue.set(data.getBytes());
        try {
            this.keyOut.set(key);
            context.write((Object)this.keyOut, (Object)this.outValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void reduce(InstOrgKey key, Iterable<Text> values, Reducer.Context context) {
        ResultCountryIterator rh = null;
        try {
            rh = new ResultCountryIterator(values, key.getKeyType().get());
        }
        catch (NotValidResultSequenceException e) {
            context.getCounter("Propagation", e.getMessage()).increment(1L);
            return;
        }
        context.getCounter("Propagation", "institutional datasource").increment(1L);
        while (rh.hasNext()) {
            OafProtos.Oaf oafUpdate = (OafProtos.Oaf)((ResultIterator)rh).next().get(0);
            this.emit(context, oafUpdate.getEntity().getId(), JsonFormat.printToString((Message)oafUpdate));
            context.getCounter("Propagation", " added country to product ").increment(1L);
        }
        if (!rh.getPropagate()) {
            context.getCounter("Propagation", "resultId expected in ordering was not found").increment(1L);
        }
    }
}

