/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.semrel;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.compositekeys.InstOrgKey;
import eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.semrel.ResultOrganizationIterator;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PropagationProductToOrganizationFileReducer
extends Reducer<InstOrgKey, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(PropagationProductToOrganizationFileReducer.class);
    private Text keyOut;
    private Text outValue;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text("");
        this.outValue = new Text();
    }

    protected void reduce(InstOrgKey key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        ResultOrganizationIterator rh = null;
        try {
            rh = new ResultOrganizationIterator(values, key.getKeyType().get());
        }
        catch (NotValidResultSequenceException e) {
            context.getCounter("Propagation", e.getMessage()).increment(1L);
            return;
        }
        while (rh.hasNext()) {
            Object oafList = ((ResultIterator)rh).next();
            Iterator iterator = oafList.iterator();
            while (iterator.hasNext()) {
                OafProtos.Oaf oaf = (OafProtos.Oaf)iterator.next();
                this.keyOut.set(oaf.getRel().getSource());
                this.outValue.set(JsonFormat.printToString((Message)oaf).getBytes());
                context.write((Object)this.keyOut, (Object)this.outValue);
            }
            context.getCounter("Propagation", "Added result to organizationtoresult").increment((long)(oafList.size() / 2));
        }
    }
}

