package eu.dnetlib.data.mapreduce.hbase.propagation.communitytoresult;

import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;

import eu.dnetlib.data.proto.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

import java.io.IOException;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import static eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.*;

public class CommunityToResultReducer extends TableReducer<Text, Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(CommunityToResultReducer.class); // NOPMD by marko on 11/24/08 5:02 PM
    private ImmutableBytesWritable keyOut;

    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {
        super.setup(context);
        keyOut = new ImmutableBytesWritable();
    }

    @Override
    protected void reduce(Text key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
        Iterator<Text> it = values.iterator();
        final ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        Set<String> added_context = new HashSet<>();
        while(it.hasNext()){
            Value v = Value.fromJson(it.next().toString());
            if (!added_context.contains(v.getValue())) {
                metadata.addContext(Utils.getContext(v.getValue(), v.getTrust(), CLASS_COMMUNITY_ID, DATA_INFO_TYPE, CLASS_COMMUNITY_NAME));
                added_context.add(v.getValue());
            }
        }

        final String rowKey = key.toString();

        final Put put = new Put(Bytes.toBytes(rowKey)).add(Bytes.toBytes("result"), Bytes.toBytes("update_" + System.nanoTime()), Utils.getUpdate(metadata, rowKey).toByteArray());
        keyOut.set(Bytes.toBytes(rowKey));
        context.write(keyOut, put);
        context.getCounter(COUNTER_PROPAGATION, "added community to result").increment(1);

    }

}

