package eu.dnetlib.data.mapreduce.hbase.bulktag;

import com.google.common.collect.Sets;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;

import java.util.Set;

public class TagginConstants {


    public final static String DATA_INFO_TYPE = "bulktagging";
    public final static String SCHEMA_NAME = "dnet:provenanceActions";
    public final static String CLASS_ID_SUBJECT = "bulktagging:community:subject";
    public final static String CLASS_ID_DATASOURCE = "bulktagging:community:datasource";
    public final static String CLASS_ID_CZENODO = "bulktagging:community:zenodocommunity";

    public final static String SCHEMA_ID = "dnet:provenanceActions";
    public final static String COUNTER_GROUP = "Bulk Tagging";

    public final static String ZENODO_COMMUNITY_INDICATOR = "zenodo.org/communities/";

    public final static int PROJECT = TypeProtos.Type.project.getNumber();//40
    public final static int DATASOURCE = TypeProtos.Type.datasource.getNumber();//10
    public final static int ORGANIZATION = TypeProtos.Type.organization.getNumber();//20
    public final static int RESULT = TypeProtos.Type.result.getNumber();//50

    public final static String CLASS_NAME_BULKTAG_SUBJECT = "Bulktagging for Community - Subject";
    public final static String CLASS_NAME_BULKTAG_DATASOURCE = "Bulktagging for Community - Datasource";
    public final static String CLASS_NAME_BULKTAG_ZENODO = "Bulktagging for Community - Zenodo";



}
