/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.model;

import eu.dnetlib.data.mapreduce.hbase.broker.mapping.DateParser;
import eu.dnetlib.data.mapreduce.hbase.broker.model.MapValueType;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapValue {
    private MapValueType type = MapValueType.STRING;
    private Object value = "";
    private static final Log log = LogFactory.getLog(MapValue.class);

    public MapValue() {
    }

    public MapValue(MapValueType type, Object value) {
        this.type = type;
        this.value = value;
    }

    public MapValueType getType() {
        return this.type;
    }

    public void setType(MapValueType type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object asObject() {
        if (this.value == null) {
            log.warn((Object)"Object is NULL");
            return null;
        }
        try {
            switch (this.type) {
                case STRING: 
                case INTEGER: 
                case FLOAT: 
                case BOOLEAN: 
                case DATE: {
                    return this.asSimpleObject(this.getType(), this.getValue().toString());
                }
                case LIST_STRING: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.STRING, o.toString())).collect(Collectors.toList());
                }
                case LIST_INTEGER: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.INTEGER, o.toString())).collect(Collectors.toList());
                }
                case LIST_FLOAT: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.FLOAT, o.toString())).collect(Collectors.toList());
                }
                case LIST_BOOLEAN: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.BOOLEAN, o.toString())).collect(Collectors.toList());
                }
                case LIST_DATE: {
                    return ((List)this.getValue()).stream().map(o -> this.asSimpleObject(MapValueType.DATE, o.toString())).collect(Collectors.toList());
                }
            }
            log.warn((Object)("Invalid type: " + (Object)((Object)this.type)));
            return null;
        }
        catch (Exception e) {
            log.warn((Object)("Error parsing value: " + this));
            return null;
        }
    }

    private Object asSimpleObject(MapValueType type, String s) {
        try {
            switch (type) {
                case STRING: {
                    return s.toString();
                }
                case INTEGER: {
                    return s.contains(".") ? NumberUtils.toLong((String)StringUtils.substringBefore((String)s, (String)"."), (long)0L) : NumberUtils.toLong((String)s, (long)0L);
                }
                case FLOAT: {
                    return NumberUtils.toDouble((String)s, (double)0.0);
                }
                case BOOLEAN: {
                    return BooleanUtils.toBoolean((String)s);
                }
                case DATE: {
                    return DateParser.parse(s);
                }
            }
            log.warn((Object)("Unmamaged type: " + (Object)((Object)type)));
            return null;
        }
        catch (Exception e) {
            log.warn((Object)("Error parsing value: " + s + " - type: " + (Object)((Object)type)));
            return null;
        }
    }

    public String toString() {
        return String.format("[ type; %s, value: %s ]", new Object[]{this.getType(), this.getValue()});
    }
}

