/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport;

import com.google.common.base.Joiner;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ExportInformationSpaceMapper
extends TableMapper<Text, Text> {
    private static final Log log = LogFactory.getLog(ExportInformationSpaceMapper.class);
    private static final String SEPARATOR = "@";
    private Text keyOut;
    private Text valueOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text();
        this.valueOut = new Text();
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            byte[] rowKey = keyIn.copyBytes();
            Stream.of(value.raw()).filter(kv -> !"".equals(Bytes.toString((byte[])kv.getValue()))).forEach(kv -> {
                try {
                    this.emit(rowKey, kv.getFamily(), kv.getQualifier(), kv.getValue(), context);
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Throwable e) {
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private void emit(byte[] rowKey, byte[] cf, byte[] q, byte[] value, Mapper.Context context) throws IOException, InterruptedException {
        this.keyOut.set(Joiner.on((String)SEPARATOR).join((Object)new String(rowKey), (Object)new String(cf), new Object[]{new String(q)}));
        if (value == null || value.length == 0) {
            this.valueOut.set("");
        } else {
            new JsonFormat();
            this.valueOut.set(JsonFormat.printToString((Message)OafDecoder.decode((byte[])value).getOaf()));
        }
        context.write((Object)this.keyOut, (Object)this.valueOut);
    }
}

